/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.time.api.KTimeUnit$WhenMappings;
import bvanseg.kotlincommons.time.api.transformer.CenturyTransformer;
import bvanseg.kotlincommons.time.api.transformer.DayTransformer;
import bvanseg.kotlincommons.time.api.transformer.DecadeTransformer;
import bvanseg.kotlincommons.time.api.transformer.HalfDayTransformer;
import bvanseg.kotlincommons.time.api.transformer.HourTransformer;
import bvanseg.kotlincommons.time.api.transformer.MicrosecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.MillenniumTransformer;
import bvanseg.kotlincommons.time.api.transformer.MillisecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.MinuteTransformer;
import bvanseg.kotlincommons.time.api.transformer.NanosecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.SecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.WeekTransformer;
import bvanseg.kotlincommons.time.api.transformer.YearTransformer;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001f"}, d2={"Lbvanseg/kotlincommons/time/api/KTimeUnit;", "", "max", "", "(Ljava/lang/String;IJ)V", "getMax", "()J", "convertTo", "", "value", "unit", "getSubUnit", "getSuperUnit", "toChronoUnit", "Ljava/time/temporal/ChronoUnit;", "NEVER", "NANOSECOND", "MICROSECOND", "MILLISECOND", "SECOND", "MINUTE", "HOUR", "HALF_DAY", "DAY", "WEEK", "YEAR", "DECADE", "CENTURY", "MILLENNIUM", "FOREVER", "Companion", "kotlincommons"})
public final class KTimeUnit
extends Enum<KTimeUnit> {
    public static final /* enum */ KTimeUnit NEVER;
    public static final /* enum */ KTimeUnit NANOSECOND;
    public static final /* enum */ KTimeUnit MICROSECOND;
    public static final /* enum */ KTimeUnit MILLISECOND;
    public static final /* enum */ KTimeUnit SECOND;
    public static final /* enum */ KTimeUnit MINUTE;
    public static final /* enum */ KTimeUnit HOUR;
    public static final /* enum */ KTimeUnit HALF_DAY;
    public static final /* enum */ KTimeUnit DAY;
    public static final /* enum */ KTimeUnit WEEK;
    public static final /* enum */ KTimeUnit YEAR;
    public static final /* enum */ KTimeUnit DECADE;
    public static final /* enum */ KTimeUnit CENTURY;
    public static final /* enum */ KTimeUnit MILLENNIUM;
    public static final /* enum */ KTimeUnit FOREVER;
    private static final /* synthetic */ KTimeUnit[] $VALUES;
    private final long max;
    public static final double NEVER_CONSTANT = Double.MIN_VALUE;
    public static final double FOREVER_CONSTANT = Double.MAX_VALUE;
    @NotNull
    public static final Companion Companion;

    static {
        KTimeUnit[] kTimeUnitArray = new KTimeUnit[15];
        KTimeUnit[] kTimeUnitArray2 = kTimeUnitArray;
        kTimeUnitArray[0] = NEVER = new KTimeUnit("NEVER", 0, 0L, 1, null);
        kTimeUnitArray[1] = NANOSECOND = new KTimeUnit(1000L);
        kTimeUnitArray[2] = MICROSECOND = new KTimeUnit(1000L);
        kTimeUnitArray[3] = MILLISECOND = new KTimeUnit(1000L);
        kTimeUnitArray[4] = SECOND = new KTimeUnit(60L);
        kTimeUnitArray[5] = MINUTE = new KTimeUnit(60L);
        kTimeUnitArray[6] = HOUR = new KTimeUnit(24L);
        kTimeUnitArray[7] = HALF_DAY = new KTimeUnit("HALF_DAY", 7, 0L, 1, null);
        kTimeUnitArray[8] = DAY = new KTimeUnit("DAY", 8, 0L, 1, null);
        kTimeUnitArray[9] = WEEK = new KTimeUnit("WEEK", 9, 0L, 1, null);
        kTimeUnitArray[10] = YEAR = new KTimeUnit("YEAR", 10, 0L, 1, null);
        kTimeUnitArray[11] = DECADE = new KTimeUnit("DECADE", 11, 0L, 1, null);
        kTimeUnitArray[12] = CENTURY = new KTimeUnit("CENTURY", 12, 0L, 1, null);
        kTimeUnitArray[13] = MILLENNIUM = new KTimeUnit("MILLENNIUM", 13, 0L, 1, null);
        kTimeUnitArray[14] = FOREVER = new KTimeUnit("FOREVER", 14, 0L, 1, null);
        $VALUES = kTimeUnitArray;
        Companion = new Companion(null);
    }

    public final double convertTo(double value, @NotNull KTimeUnit unit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (value == 0.0) {
            return 0.0;
        }
        double d2 = value;
        boolean bl = false;
        if (Double.isNaN(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a valid time value but got " + value + " instead.");
        }
        d2 = value;
        bl = false;
        if (Double.isInfinite(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a finite value but got " + value + " instead.");
        }
        if (value < 0.0) {
            throw (Throwable)new IllegalArgumentException("Time value can not be negative: " + value + '.');
        }
        switch (KTimeUnit$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                d = Double.MIN_VALUE;
                break;
            }
            case 2: {
                d = NanosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 3: {
                d = MicrosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 4: {
                d = MillisecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 5: {
                d = SecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 6: {
                d = MinuteTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 7: {
                d = HourTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 8: {
                d = HalfDayTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 9: {
                d = DayTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 10: {
                d = WeekTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 11: {
                d = YearTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 12: {
                d = DecadeTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 13: {
                d = CenturyTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 14: {
                d = MillenniumTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 15: {
                d = Double.MAX_VALUE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @NotNull
    public final KTimeUnit getSubUnit() {
        KTimeUnit kTimeUnit = (KTimeUnit)((Object)ArraysKt.getOrNull((Object[])KTimeUnit.values(), (int)(this.ordinal() - 1)));
        if (kTimeUnit == null) {
            kTimeUnit = NEVER;
        }
        return kTimeUnit;
    }

    @NotNull
    public final KTimeUnit getSuperUnit() {
        KTimeUnit kTimeUnit = (KTimeUnit)((Object)ArraysKt.getOrNull((Object[])KTimeUnit.values(), (int)(this.ordinal() + 1)));
        if (kTimeUnit == null) {
            kTimeUnit = FOREVER;
        }
        return kTimeUnit;
    }

    @Nullable
    public final ChronoUnit toChronoUnit() {
        ChronoUnit chronoUnit;
        switch (KTimeUnit$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                chronoUnit = null;
                break;
            }
            case 2: {
                chronoUnit = ChronoUnit.NANOS;
                break;
            }
            case 3: {
                chronoUnit = ChronoUnit.MICROS;
                break;
            }
            case 4: {
                chronoUnit = ChronoUnit.MILLIS;
                break;
            }
            case 5: {
                chronoUnit = ChronoUnit.SECONDS;
                break;
            }
            case 6: {
                chronoUnit = ChronoUnit.MINUTES;
                break;
            }
            case 7: {
                chronoUnit = ChronoUnit.HOURS;
                break;
            }
            case 8: {
                chronoUnit = ChronoUnit.HALF_DAYS;
                break;
            }
            case 9: {
                chronoUnit = ChronoUnit.DAYS;
                break;
            }
            case 10: {
                chronoUnit = ChronoUnit.WEEKS;
                break;
            }
            case 11: {
                chronoUnit = ChronoUnit.YEARS;
                break;
            }
            case 12: {
                chronoUnit = ChronoUnit.DECADES;
                break;
            }
            case 13: {
                chronoUnit = ChronoUnit.CENTURIES;
                break;
            }
            case 14: {
                chronoUnit = ChronoUnit.MILLENNIA;
                break;
            }
            case 15: {
                chronoUnit = ChronoUnit.FOREVER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return chronoUnit;
    }

    public final long getMax() {
        return this.max;
    }

    private KTimeUnit(long max) {
        this.max = max;
    }

    /* synthetic */ KTimeUnit(String string2, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = 1L;
        }
        this(l);
    }

    public static KTimeUnit[] values() {
        return (KTimeUnit[])$VALUES.clone();
    }

    public static KTimeUnit valueOf(String string2) {
        return Enum.valueOf(KTimeUnit.class, string2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lbvanseg/kotlincommons/time/api/KTimeUnit$Companion;", "", "()V", "FOREVER_CONSTANT", "", "NEVER_CONSTANT", "kotlincommons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

