/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.util.ratelimit;

import bvanseg.kotlincommons.io.logging.LoggerExtensionsKt;
import bvanseg.kotlincommons.time.api.KTime;
import bvanseg.kotlincommons.time.api.KTimeAPIKt;
import bvanseg.kotlincommons.time.api.KTimePerformer;
import bvanseg.kotlincommons.util.concurrent.KCountDownLatch;
import bvanseg.kotlincommons.util.event.CallbackEvent;
import bvanseg.kotlincommons.util.event.EventBus;
import bvanseg.kotlincommons.util.ratelimit.RateLimiter;
import bvanseg.kotlincommons.util.ratelimit.TokenBucket;
import bvanseg.kotlincommons.util.ratelimit.event.BucketRefillEvent;
import bvanseg.kotlincommons.util.ratelimit.event.RateLimiterShutdownEvent;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0007J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\fH\u0002J\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020\u000eJ\u001e\u0010+\u001a\u00020\u000e2\b\b\u0002\u0010(\u001a\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010-\u001a\u00020\u000e2\b\b\u0002\u0010(\u001a\u00020\fJ)\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\b\b\u0002\u0010(\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.0\r\u00a2\u0006\u0002\u00100R&\u0010\t\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lbvanseg/kotlincommons/util/ratelimit/RateLimiter;", "", "tokenBucket", "Lbvanseg/kotlincommons/util/ratelimit/TokenBucket;", "eventBus", "Lbvanseg/kotlincommons/util/event/EventBus;", "autoStart", "", "(Lbvanseg/kotlincommons/util/ratelimit/TokenBucket;Lbvanseg/kotlincommons/util/event/EventBus;Z)V", "asyncDeque", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lkotlin/Pair;", "", "Lkotlin/Function0;", "", "cycleStrategy", "Lkotlin/Function1;", "getCycleStrategy", "()Lkotlin/jvm/functions/Function1;", "setCycleStrategy", "(Lkotlin/jvm/functions/Function1;)V", "getEventBus", "()Lbvanseg/kotlincommons/util/event/EventBus;", "exceptionStrategy", "", "getExceptionStrategy", "setExceptionStrategy", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "shutdownStrategy", "getShutdownStrategy", "()Lkotlin/jvm/functions/Function0;", "setShutdownStrategy", "(Lkotlin/jvm/functions/Function0;)V", "getTokenBucket", "()Lbvanseg/kotlincommons/util/ratelimit/TokenBucket;", "calculateSleepTime", "flag", "isConsumeValid", "consume", "shutdown", "start", "submit", "ratelimitCallback", "submitBlocking", "R", "callback", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "kotlincommons"})
public final class RateLimiter {
    @NotNull
    private Function1<? super Throwable, Unit> exceptionStrategy;
    @NotNull
    private Function1<? super RateLimiter, Unit> cycleStrategy;
    @NotNull
    private Function0<Unit> shutdownStrategy;
    private final LinkedBlockingDeque<Pair<Long, Function0<Unit>>> asyncDeque;
    @NotNull
    private final AtomicBoolean isRunning;
    @NotNull
    private final TokenBucket tokenBucket;
    @NotNull
    private final EventBus eventBus;
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Function1<Throwable, Unit> getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    public final void setExceptionStrategy(@NotNull Function1<? super Throwable, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.exceptionStrategy = function1;
    }

    @NotNull
    public final Function1<RateLimiter, Unit> getCycleStrategy() {
        return this.cycleStrategy;
    }

    public final void setCycleStrategy(@NotNull Function1<? super RateLimiter, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.cycleStrategy = function1;
    }

    @NotNull
    public final Function0<Unit> getShutdownStrategy() {
        return this.shutdownStrategy;
    }

    public final void setShutdownStrategy(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.shutdownStrategy = function0;
    }

    @NotNull
    public final AtomicBoolean isRunning() {
        return this.isRunning;
    }

    public final long calculateSleepTime(boolean flag) {
        long snapshotMillis = System.currentTimeMillis() % this.tokenBucket.getRefillTime();
        return this.tokenBucket.getRefillTime() - snapshotMillis + (flag ? this.tokenBucket.getRefillTimeOffset() : 0L);
    }

    public final void submit(long consume, @NotNull Function0<Unit> ratelimitCallback) {
        Intrinsics.checkNotNullParameter(ratelimitCallback, (String)"ratelimitCallback");
        if (!this.isConsumeValid(consume)) {
            return;
        }
        logger.trace("Received asynchronous submission.");
        this.asyncDeque.addLast((Pair<Long, Function0<Unit>>)TuplesKt.to((Object)consume, ratelimitCallback));
    }

    public static /* synthetic */ void submit$default(RateLimiter rateLimiter, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        rateLimiter.submit(l, (Function0<Unit>)function0);
    }

    public final <R> R submitBlocking(long consume, @NotNull Function0<? extends R> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.submitBlocking(consume);
        return (R)callback.invoke();
    }

    public static /* synthetic */ Object submitBlocking$default(RateLimiter rateLimiter, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        return rateLimiter.submitBlocking(l, function0);
    }

    /*
     * WARNING - void declaration
     */
    public final void submitBlocking(long consume) {
        while (!this.tokenBucket.tryConsume(consume)) {
            void this_$iv$iv;
            EventBus this_$iv = EventBus.Companion.getDEFAULT();
            boolean $i$f$awaitThreadEvent = false;
            CountDownLatch latch$iv = new CountDownLatch(1);
            EventBus eventBus = this_$iv;
            Function1 callback$iv$iv = new Function1<T, Unit>(latch$iv){
                final /* synthetic */ CountDownLatch $latch;

                public final void invoke(@NotNull T it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    this.$latch.countDown();
                }
                {
                    this.$latch = countDownLatch;
                    super(1);
                }
            };
            boolean $i$f$on = false;
            Class<BucketRefillEvent.POST> callbackClass$iv$iv = BucketRefillEvent.POST.class;
            this_$iv$iv.getCallbackListeners().computeIfAbsent(callbackClass$iv$iv, EventBus.on.1.INSTANCE).add(new CallbackEvent(callback$iv$iv));
            latch$iv.await();
        }
    }

    public static /* synthetic */ void submitBlocking$default(RateLimiter rateLimiter, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        rateLimiter.submitBlocking(l);
    }

    private final boolean isConsumeValid(long consume) {
        boolean bl;
        if (consume < 0L) {
            logger.warn("Consume count for rate limiter submission can not be negative: {}", (Object)consume);
            bl = false;
        } else if (consume > this.tokenBucket.getTokenLimit()) {
            logger.warn("Consume count for rate limiter submission can not be greater than token limit: {}/{}", (Object)consume, (Object)this.tokenBucket.getTokenLimit());
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public final void start() {
        if (this.isRunning.getAndSet(true)) {
            logger.warn("Attempted to start RateLimiter but it is already running!");
            return;
        }
        logger.trace("Starting RateLimiter...");
        this.cycleStrategy.invoke((Object)this);
    }

    public final void shutdown() {
        RateLimiterShutdownEvent.PRE preShutdownEvent = new RateLimiterShutdownEvent.PRE(this);
        RateLimiterShutdownEvent.POST postShutdownEvent = new RateLimiterShutdownEvent.POST(this);
        logger.trace("Shutting down RateLimiter...");
        this.eventBus.fire(preShutdownEvent);
        this.isRunning.set(false);
        this.shutdownStrategy.invoke();
        this.eventBus.fire(postShutdownEvent);
    }

    @NotNull
    public final TokenBucket getTokenBucket() {
        return this.tokenBucket;
    }

    @NotNull
    public final EventBus getEventBus() {
        return this.eventBus;
    }

    public RateLimiter(@NotNull TokenBucket tokenBucket, @NotNull EventBus eventBus, boolean autoStart) {
        Intrinsics.checkNotNullParameter((Object)tokenBucket, (String)"tokenBucket");
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        this.tokenBucket = tokenBucket;
        this.eventBus = eventBus;
        this.exceptionStrategy = exceptionStrategy.1.INSTANCE;
        this.cycleStrategy = (Function1)new Function1<RateLimiter, Unit>(this){
            final /* synthetic */ RateLimiter this$0;

            public final void invoke(@NotNull RateLimiter rateLimiter) {
                Intrinsics.checkNotNullParameter((Object)rateLimiter, (String)"rateLimiter");
                KTime initDelta = KTimeAPIKt.getMilliseconds(this.this$0.calculateSleepTime(false));
                KTimeAPIKt.every(this.this$0.getTokenBucket().getRefillTime(), true, (Function1<? super KTimePerformer, Unit>)((Function1)new Function1<KTimePerformer, Unit>(this){
                    final /* synthetic */ cycleStrategy.1 this$0;

                    public final void invoke(@NotNull KTimePerformer performer) {
                        Intrinsics.checkNotNullParameter((Object)performer, (String)"performer");
                        BucketRefillEvent.PRE preRefillEvent = new BucketRefillEvent.PRE(this.this$0.this$0);
                        BucketRefillEvent.POST postRefillEvent = new BucketRefillEvent.POST(this.this$0.this$0);
                        this.this$0.this$0.getEventBus().fire(preRefillEvent);
                        this.this$0.this$0.getTokenBucket().refill();
                        this.this$0.this$0.getEventBus().fire(postRefillEvent);
                        if (!this.this$0.this$0.isRunning().get()) {
                            performer.stop();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })).delay(initDelta).offsetMillis(this.this$0.getTokenBucket().getRefillTimeOffset()).execute(true);
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, rateLimiter, null){
                    int label;
                    final /* synthetic */ cycleStrategy.1 this$0;
                    final /* synthetic */ RateLimiter $rateLimiter;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2;
                        boolean $i$f$awaitCoroutineEvent;
                        Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                break;
                            }
                            case 1: {
                                void $result;
                                $i$f$awaitCoroutineEvent = false;
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                            }
                            default: {
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }
                        while (this.$rateLimiter.isRunning().get()) {
                            try {
                                void this_$iv$iv;
                                Pair next;
                                if ((Pair)RateLimiter.access$getAsyncDeque$p(this.$rateLimiter).takeFirst() == null) continue;
                                long cost = ((Number)next.getFirst()).longValue();
                                if (this.this$0.this$0.getTokenBucket().tryConsume(cost)) {
                                    Function0 function0 = (Function0)next.getSecond();
                                    RateLimiter.Companion.getLogger().trace("Executing queued submission: TokenBucket ({}/{}).", (Object)this.this$0.this$0.getTokenBucket().getCurrentTokenCount(), (Object)Boxing.boxLong((long)this.this$0.this$0.getTokenBucket().getTokenLimit()));
                                    try {
                                        function0.invoke();
                                        RateLimiter.Companion.getLogger().trace("Finished executing queued submission: TokenBucket ({}/{}).", (Object)this.this$0.this$0.getTokenBucket().getCurrentTokenCount(), (Object)Boxing.boxLong((long)this.this$0.this$0.getTokenBucket().getTokenLimit()));
                                    }
                                    catch (Exception e) {
                                        this.this$0.this$0.getExceptionStrategy().invoke((Object)e);
                                    }
                                    continue;
                                }
                                RateLimiter.access$getAsyncDeque$p(this.$rateLimiter).offerFirst(next);
                                EventBus eventBus = EventBus.Companion.getDEFAULT();
                                cycleStrategy.2 var6_9 = this;
                                $i$f$awaitCoroutineEvent = false;
                                KCountDownLatch latch$iv = new KCountDownLatch(1);
                                EventBus eventBus2 = eventBus;
                                Function1 callback$iv$iv = (Function1)new Function1<T, Unit>(latch$iv){
                                    final /* synthetic */ KCountDownLatch $latch;

                                    public final void invoke(@NotNull T it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        this.$latch.countDown();
                                    }
                                    {
                                        this.$latch = kCountDownLatch;
                                        super(1);
                                    }
                                };
                                boolean $i$f$on = false;
                                Class<BucketRefillEvent.POST> callbackClass$iv$iv = BucketRefillEvent.POST.class;
                                this_$iv$iv.getCallbackListeners().computeIfAbsent(callbackClass$iv$iv, EventBus.on.1.INSTANCE).add(new CallbackEvent<T>(callback$iv$iv));
                                this.label = 1;
                                object2 = latch$iv.await((Continuation<? super Unit>)var6_9);
                                if (object2 != object3) continue;
                            }
                            catch (Exception e) {
                                this.this$0.this$0.getExceptionStrategy().invoke((Object)e);
                            }
                            return object3;
                        }
                        return Unit.INSTANCE;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$rateLimiter = rateLimiter;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            {
                this.this$0 = rateLimiter;
                super(1);
            }
        };
        this.shutdownStrategy = (Function0)new Function0<Unit>(this){
            final /* synthetic */ RateLimiter this$0;

            public final void invoke() {
                RateLimiter.access$getAsyncDeque$p(this.this$0).clear();
            }
            {
                this.this$0 = rateLimiter;
                super(0);
            }
        };
        this.asyncDeque = new LinkedBlockingDeque();
        this.isRunning = new AtomicBoolean();
        if (autoStart) {
            this.start();
        }
    }

    public /* synthetic */ RateLimiter(TokenBucket tokenBucket, EventBus eventBus, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            eventBus = EventBus.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(tokenBucket, eventBus, bl);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerExtensionsKt.getLogger(Companion);
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getAsyncDeque$p(RateLimiter $this) {
        return $this.asyncDeque;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lbvanseg/kotlincommons/util/ratelimit/RateLimiter$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

