/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.util.ratelimit;

import bvanseg.kotlincommons.io.logging.LoggerExtensionsKt;
import bvanseg.kotlincommons.util.HashCodeBuilder;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J\u0015\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\nH\u00c2\u0003JQ\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020\"J\u0006\u0010'\u001a\u00020\"J\u0006\u0010(\u001a\u00020\"J\u0006\u0010)\u001a\u00020\"J\u0006\u0010*\u001a\u00020\u000bJ\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0010\u0010-\u001a\u00020\"2\b\b\u0002\u0010.\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u00060"}, d2={"Lbvanseg/kotlincommons/util/ratelimit/TokenBucket;", "", "tokenLimit", "", "refillTime", "refillTimeOffset", "initUpdate", "currentTokenCount", "Ljava/util/concurrent/atomic/AtomicLong;", "refreshStrategy", "Lkotlin/Function1;", "", "(JJJJLjava/util/concurrent/atomic/AtomicLong;Lkotlin/jvm/functions/Function1;)V", "getCurrentTokenCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "setCurrentTokenCount", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "<set-?>", "lastUpdate", "getLastUpdate", "()J", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getRefillTime", "getRefillTimeOffset", "getTokenLimit", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "isEmpty", "isFull", "isNotEmpty", "isNotFull", "refill", "toString", "", "tryConsume", "amount", "Companion", "kotlincommons"})
public final class TokenBucket {
    private volatile long lastUpdate;
    private final ReentrantLock lock;
    private final long tokenLimit;
    private final long refillTime;
    private final long refillTimeOffset;
    private final long initUpdate;
    @NotNull
    private AtomicLong currentTokenCount;
    private final Function1<TokenBucket, Unit> refreshStrategy;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final long getLastUpdate() {
        return this.lastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refill() {
        String string2;
        Logger logger;
        boolean $i$f$trace;
        Logger $this$trace$iv;
        try {
            $this$trace$iv = TokenBucket.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                string2 = "Preparing to enter lock in TokenBucket#refill... ";
                logger.trace(string2.toString());
            }
            this.lock.lock();
            if (this.currentTokenCount.get() < this.tokenLimit) {
                TokenBucket.logger.debug("Refreshing tokens: TokenBucket ({}/{}).", (Object)this.currentTokenCount, (Object)this.tokenLimit);
                this.refreshStrategy.invoke((Object)this);
                TokenBucket.logger.debug("Finished refreshing tokens: TokenBucket ({}/{}).", (Object)this.currentTokenCount, (Object)this.tokenLimit);
                this.lastUpdate = System.currentTimeMillis();
            } else {
                $this$trace$iv = TokenBucket.logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    string2 = "Token bucket is full, " + this.currentTokenCount + '/' + this.tokenLimit;
                    logger.trace(string2.toString());
                }
            }
        }
        finally {
            this.lock.unlock();
            $this$trace$iv = TokenBucket.logger;
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                string2 = "Successfully left lock in TokenBucket#refill!";
                logger.trace(string2.toString());
            }
        }
    }

    public final boolean isFull() {
        return this.currentTokenCount.get() == this.tokenLimit;
    }

    public final boolean isNotFull() {
        return this.currentTokenCount.get() != this.tokenLimit;
    }

    public final boolean isEmpty() {
        return this.currentTokenCount.get() == 0L;
    }

    public final boolean isNotEmpty() {
        return this.currentTokenCount.get() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryConsume(long amount) {
        String string2;
        Logger logger;
        if (amount < 0L) {
            throw (Throwable)new IllegalArgumentException("Consume amount may not be negative!");
        }
        try {
            Logger $this$trace$iv = TokenBucket.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                string2 = "Preparing to enter lock in TokenBucket#tryConsume...";
                logger.trace(string2.toString());
            }
            this.lock.lock();
            if (this.currentTokenCount.get() >= amount) {
                this.currentTokenCount.addAndGet(-amount);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
            Logger $this$trace$iv = TokenBucket.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                string2 = "Successfully left lock in TokenBucket#tryConsume!";
                logger.trace(string2.toString());
            }
        }
    }

    public static /* synthetic */ boolean tryConsume$default(TokenBucket tokenBucket, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 1L;
        }
        return tokenBucket.tryConsume(l);
    }

    public int hashCode() {
        return HashCodeBuilder.Companion.builder(Reflection.getOrCreateKotlinClass(this.getClass())).append(this.tokenLimit).append(this.refillTime).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type bvanseg.kotlincommons.util.ratelimit.TokenBucket");
        }
        TokenBucket cfr_ignored_0 = (TokenBucket)object2;
        if (this.tokenLimit != ((TokenBucket)other).tokenLimit) {
            return false;
        }
        if (this.refillTime != ((TokenBucket)other).refillTime) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.currentTokenCount, (Object)((TokenBucket)other).currentTokenCount) ^ true);
    }

    public final long getTokenLimit() {
        return this.tokenLimit;
    }

    public final long getRefillTime() {
        return this.refillTime;
    }

    public final long getRefillTimeOffset() {
        return this.refillTimeOffset;
    }

    @NotNull
    public final AtomicLong getCurrentTokenCount() {
        return this.currentTokenCount;
    }

    public final void setCurrentTokenCount(@NotNull AtomicLong atomicLong) {
        Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
        this.currentTokenCount = atomicLong;
    }

    public TokenBucket(long tokenLimit, long refillTime, long refillTimeOffset, long initUpdate, @NotNull AtomicLong currentTokenCount, @NotNull Function1<? super TokenBucket, Unit> refreshStrategy) {
        Intrinsics.checkNotNullParameter((Object)currentTokenCount, (String)"currentTokenCount");
        Intrinsics.checkNotNullParameter(refreshStrategy, (String)"refreshStrategy");
        this.tokenLimit = tokenLimit;
        this.refillTime = refillTime;
        this.refillTimeOffset = refillTimeOffset;
        this.initUpdate = initUpdate;
        this.currentTokenCount = currentTokenCount;
        this.refreshStrategy = refreshStrategy;
        this.lastUpdate = this.initUpdate;
        this.lock = new ReentrantLock(true);
    }

    public /* synthetic */ TokenBucket(final long l, long l2, long l3, long l4, AtomicLong atomicLong, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l3 = 0L;
        }
        if ((n & 8) != 0) {
            l4 = System.currentTimeMillis();
        }
        if ((n & 0x10) != 0) {
            atomicLong = new AtomicLong(l);
        }
        if ((n & 0x20) != 0) {
            function1 = (Function1)new Function1<TokenBucket, Unit>(){

                public final void invoke(@NotNull TokenBucket it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.getCurrentTokenCount().set(l);
                }
            };
        }
        this(l, l2, l3, l4, atomicLong, (Function1<? super TokenBucket, Unit>)function1);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerExtensionsKt.getLogger(Companion);
    }

    public final long component1() {
        return this.tokenLimit;
    }

    public final long component2() {
        return this.refillTime;
    }

    public final long component3() {
        return this.refillTimeOffset;
    }

    private final long component4() {
        return this.initUpdate;
    }

    @NotNull
    public final AtomicLong component5() {
        return this.currentTokenCount;
    }

    private final Function1<TokenBucket, Unit> component6() {
        return this.refreshStrategy;
    }

    @NotNull
    public final TokenBucket copy(long tokenLimit, long refillTime, long refillTimeOffset, long initUpdate, @NotNull AtomicLong currentTokenCount, @NotNull Function1<? super TokenBucket, Unit> refreshStrategy) {
        Intrinsics.checkNotNullParameter((Object)currentTokenCount, (String)"currentTokenCount");
        Intrinsics.checkNotNullParameter(refreshStrategy, (String)"refreshStrategy");
        return new TokenBucket(tokenLimit, refillTime, refillTimeOffset, initUpdate, currentTokenCount, refreshStrategy);
    }

    public static /* synthetic */ TokenBucket copy$default(TokenBucket tokenBucket, long l, long l2, long l3, long l4, AtomicLong atomicLong, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = tokenBucket.tokenLimit;
        }
        if ((n & 2) != 0) {
            l2 = tokenBucket.refillTime;
        }
        if ((n & 4) != 0) {
            l3 = tokenBucket.refillTimeOffset;
        }
        if ((n & 8) != 0) {
            l4 = tokenBucket.initUpdate;
        }
        if ((n & 0x10) != 0) {
            atomicLong = tokenBucket.currentTokenCount;
        }
        if ((n & 0x20) != 0) {
            function1 = tokenBucket.refreshStrategy;
        }
        return tokenBucket.copy(l, l2, l3, l4, atomicLong, function1);
    }

    @NotNull
    public String toString() {
        return "TokenBucket(tokenLimit=" + this.tokenLimit + ", refillTime=" + this.refillTime + ", refillTimeOffset=" + this.refillTimeOffset + ", initUpdate=" + this.initUpdate + ", currentTokenCount=" + this.currentTokenCount + ", refreshStrategy=" + this.refreshStrategy + ")";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lbvanseg/kotlincommons/util/ratelimit/TokenBucket$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlincommons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

