/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.lang.string;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a.\u0010\u0003\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a#\u0010\n\u001a\u00020\u0002*\u00020\u00022\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f\"\u00020\u0002\u00a2\u0006\u0002\u0010\r\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u00020\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u00a8\u0006\u0018"}, d2={"fromBase64", "", "", "joinStrings", "", "separator", "", "startIndex", "", "endIndex", "remove", "strings", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "toBase64", "toURI", "Ljava/net/URI;", "toURIOrNull", "toURL", "Ljava/net/URL;", "toURLOrNull", "truncate", "n", "truncated", "kotlincommons"})
public final class StringExtensionsKt {
    @NotNull
    public static final String joinStrings(@NotNull List<String> $this$joinStrings, @NotNull CharSequence separator, int startIndex, int endIndex) {
        int end;
        int n;
        Intrinsics.checkNotNullParameter($this$joinStrings, (String)"$this$joinStrings");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        StringBuilder sb = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int start = Math.max(startIndex, n2);
        if (endIndex < 0) {
            n = $this$joinStrings.size();
        } else {
            n3 = $this$joinStrings.size();
            boolean bl = false;
            n = end = Math.min(endIndex, n3);
        }
        if (start > end) {
            throw (Throwable)new IllegalArgumentException("Start index (" + start + ") must not be greater than the end index (" + end + ')');
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)start, (int)end);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (it > start) {
                sb.append(separator);
            }
            sb.append($this$joinStrings.get(it));
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    public static /* synthetic */ String joinStrings$default(List list, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            charSequence = " ";
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = -1;
        }
        return StringExtensionsKt.joinStrings(list, charSequence, n, n2);
    }

    @NotNull
    public static final String remove(@NotNull String $this$remove, String ... strings) {
        Intrinsics.checkNotNullParameter((Object)$this$remove, (String)"$this$remove");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        StringBuilder str = new StringBuilder($this$remove);
        for (String current : strings) {
            int index = str.indexOf(current);
            while (index != -1) {
                str.replace(index, index + current.length(), "");
                index = str.indexOf(current);
            }
        }
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"str.toString()");
        return string2;
    }

    @NotNull
    public static final URI toURI(@NotNull String $this$toURI) {
        Intrinsics.checkNotNullParameter((Object)$this$toURI, (String)"$this$toURI");
        URI uRI = URI.create($this$toURI);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI.create(this)");
        return uRI;
    }

    @NotNull
    public static final URL toURL(@NotNull String $this$toURL) {
        Intrinsics.checkNotNullParameter((Object)$this$toURL, (String)"$this$toURL");
        return new URL($this$toURL);
    }

    @Nullable
    public static final URI toURIOrNull(@NotNull String $this$toURIOrNull) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)$this$toURIOrNull, (String)"$this$toURIOrNull");
        try {
            uRI = URI.create($this$toURIOrNull);
        }
        catch (Exception e) {
            uRI = null;
        }
        return uRI;
    }

    @Nullable
    public static final URL toURLOrNull(@NotNull String $this$toURLOrNull) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)$this$toURLOrNull, (String)"$this$toURLOrNull");
        try {
            uRL = new URL($this$toURLOrNull);
        }
        catch (Exception e) {
            uRL = null;
        }
        return uRL;
    }

    @NotNull
    public static final String toBase64(@NotNull String $this$toBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$toBase64, (String)"$this$toBase64");
        Base64.Encoder encoder = Base64.getEncoder();
        String string2 = $this$toBase64;
        Charset charset = Charsets.US_ASCII;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().enco\u2026Array(Charsets.US_ASCII))");
        return string3;
    }

    @NotNull
    public static final byte[] fromBase64(@NotNull String $this$fromBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$fromBase64, (String)"$this$fromBase64");
        byte[] byArray = Base64.getDecoder().decode($this$fromBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.getDecoder().decode(this)");
        return byArray;
    }

    @NotNull
    public static final String truncate(@NotNull String $this$truncate, int n, @NotNull String truncated) {
        Intrinsics.checkNotNullParameter((Object)$this$truncate, (String)"$this$truncate");
        Intrinsics.checkNotNullParameter((Object)truncated, (String)"truncated");
        return $this$truncate.length() <= n ? $this$truncate : StringsKt.take((String)$this$truncate, (int)(n - truncated.length())) + truncated;
    }

    public static /* synthetic */ String truncate$default(String string2, int n, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string3 = "...";
        }
        return StringExtensionsKt.truncate(string2, n, string3);
    }
}

