/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.time.api;

import bvanseg.kotlincommons.time.api.KhronoUnit$WhenMappings;
import bvanseg.kotlincommons.time.api.transformer.CenturyTransformer;
import bvanseg.kotlincommons.time.api.transformer.DayTransformer;
import bvanseg.kotlincommons.time.api.transformer.DecadeTransformer;
import bvanseg.kotlincommons.time.api.transformer.HalfDayTransformer;
import bvanseg.kotlincommons.time.api.transformer.HourTransformer;
import bvanseg.kotlincommons.time.api.transformer.MicrosecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.MillenniumTransformer;
import bvanseg.kotlincommons.time.api.transformer.MillisecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.MinuteTransformer;
import bvanseg.kotlincommons.time.api.transformer.NanosecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.SecondTransformer;
import bvanseg.kotlincommons.time.api.transformer.WeekTransformer;
import bvanseg.kotlincommons.time.api.transformer.YearTransformer;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0001\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u001b\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006\""}, d2={"Lbvanseg/kotlincommons/time/api/KhronoUnit;", "", "max", "", "calendarUnit", "(Ljava/lang/String;IDD)V", "getCalendarUnit", "()D", "getMax", "convertTo", "value", "unit", "getSubUnit", "getSuperUnit", "toChronoUnit", "Ljava/time/temporal/ChronoUnit;", "toTimeUnit", "Ljava/util/concurrent/TimeUnit;", "NEVER", "NANOSECOND", "MICROSECOND", "MILLISECOND", "SECOND", "MINUTE", "HOUR", "HALF_DAY", "DAY", "WEEK", "YEAR", "DECADE", "CENTURY", "MILLENNIUM", "FOREVER", "Companion", "kotlincommons"})
public final class KhronoUnit
extends Enum<KhronoUnit> {
    public static final /* enum */ KhronoUnit NEVER;
    public static final /* enum */ KhronoUnit NANOSECOND;
    public static final /* enum */ KhronoUnit MICROSECOND;
    public static final /* enum */ KhronoUnit MILLISECOND;
    public static final /* enum */ KhronoUnit SECOND;
    public static final /* enum */ KhronoUnit MINUTE;
    public static final /* enum */ KhronoUnit HOUR;
    public static final /* enum */ KhronoUnit HALF_DAY;
    public static final /* enum */ KhronoUnit DAY;
    public static final /* enum */ KhronoUnit WEEK;
    public static final /* enum */ KhronoUnit YEAR;
    public static final /* enum */ KhronoUnit DECADE;
    public static final /* enum */ KhronoUnit CENTURY;
    public static final /* enum */ KhronoUnit MILLENNIUM;
    public static final /* enum */ KhronoUnit FOREVER;
    private static final /* synthetic */ KhronoUnit[] $VALUES;
    private final double max;
    private final double calendarUnit;
    public static final double NEVER_CONSTANT = Double.MIN_VALUE;
    public static final double FOREVER_CONSTANT = Double.MAX_VALUE;
    @NotNull
    public static final Companion Companion;

    static {
        KhronoUnit[] khronoUnitArray = new KhronoUnit[15];
        KhronoUnit[] khronoUnitArray2 = khronoUnitArray;
        khronoUnitArray[0] = NEVER = new KhronoUnit("NEVER", 0, 0.0, 0.0, 3, null);
        khronoUnitArray[1] = NANOSECOND = new KhronoUnit("NANOSECOND", 1, 1000.0, 0.0, 2, null);
        khronoUnitArray[2] = MICROSECOND = new KhronoUnit("MICROSECOND", 2, 1000.0, 0.0, 2, null);
        khronoUnitArray[3] = MILLISECOND = new KhronoUnit("MILLISECOND", 3, 1000.0, 0.0, 2, null);
        khronoUnitArray[4] = SECOND = new KhronoUnit("SECOND", 4, 60.0, 0.0, 2, null);
        khronoUnitArray[5] = MINUTE = new KhronoUnit("MINUTE", 5, 60.0, 0.0, 2, null);
        khronoUnitArray[6] = HOUR = new KhronoUnit("HOUR", 6, 24.0, 0.0, 2, null);
        khronoUnitArray[7] = HALF_DAY = new KhronoUnit(2.0, 11.966666666666667);
        khronoUnitArray[8] = DAY = new KhronoUnit(7.0, 23.933333333333334);
        khronoUnitArray[9] = WEEK = new KhronoUnit(3.999999999999912, 7.609212479166667);
        khronoUnitArray[10] = YEAR = new KhronoUnit(10.0, 365.242199);
        khronoUnitArray[11] = DECADE = new KhronoUnit(10.0, (double)10 * KhronoUnit.YEAR.calendarUnit);
        khronoUnitArray[12] = CENTURY = new KhronoUnit(10.0, (double)100 * KhronoUnit.YEAR.calendarUnit);
        khronoUnitArray[13] = MILLENNIUM = new KhronoUnit("MILLENNIUM", 13, 0.0, (double)1000 * KhronoUnit.YEAR.calendarUnit, 1, null);
        khronoUnitArray[14] = FOREVER = new KhronoUnit("FOREVER", 14, 0.0, 0.0, 3, null);
        $VALUES = khronoUnitArray;
        Companion = new Companion(null);
    }

    public final double convertTo(double value, @NotNull KhronoUnit unit) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (value == 0.0) {
            return 0.0;
        }
        double d2 = value;
        boolean bl = false;
        if (Double.isNaN(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a valid time value but got " + value + " instead.");
        }
        d2 = value;
        bl = false;
        if (Double.isInfinite(d2)) {
            throw (Throwable)new IllegalArgumentException("Expected a finite value but got " + value + " instead.");
        }
        if (value < 0.0) {
            throw (Throwable)new IllegalArgumentException("Time value can not be negative: " + value + '.');
        }
        switch (KhronoUnit$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                d = Double.MIN_VALUE;
                break;
            }
            case 2: {
                d = NanosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 3: {
                d = MicrosecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 4: {
                d = MillisecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 5: {
                d = SecondTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 6: {
                d = MinuteTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 7: {
                d = HourTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 8: {
                d = HalfDayTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 9: {
                d = DayTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 10: {
                d = WeekTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 11: {
                d = YearTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 12: {
                d = DecadeTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 13: {
                d = CenturyTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 14: {
                d = MillenniumTransformer.INSTANCE.transform(value, unit);
                break;
            }
            case 15: {
                d = Double.MAX_VALUE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @NotNull
    public final KhronoUnit getSubUnit() {
        KhronoUnit khronoUnit = (KhronoUnit)((Object)ArraysKt.getOrNull((Object[])KhronoUnit.values(), (int)(this.ordinal() - 1)));
        if (khronoUnit == null) {
            khronoUnit = NEVER;
        }
        return khronoUnit;
    }

    @NotNull
    public final KhronoUnit getSuperUnit() {
        KhronoUnit khronoUnit = (KhronoUnit)((Object)ArraysKt.getOrNull((Object[])KhronoUnit.values(), (int)(this.ordinal() + 1)));
        if (khronoUnit == null) {
            khronoUnit = FOREVER;
        }
        return khronoUnit;
    }

    @Nullable
    public final TimeUnit toTimeUnit() {
        TimeUnit timeUnit;
        switch (KhronoUnit$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                timeUnit = TimeUnit.NANOSECONDS;
                break;
            }
            case 2: {
                timeUnit = TimeUnit.MICROSECONDS;
                break;
            }
            case 3: {
                timeUnit = TimeUnit.MILLISECONDS;
                break;
            }
            case 4: {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case 5: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 6: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 7: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                timeUnit = null;
            }
        }
        return timeUnit;
    }

    @Nullable
    public final ChronoUnit toChronoUnit() {
        ChronoUnit chronoUnit;
        switch (KhronoUnit$WhenMappings.$EnumSwitchMapping$2[this.ordinal()]) {
            case 1: {
                chronoUnit = null;
                break;
            }
            case 2: {
                chronoUnit = ChronoUnit.NANOS;
                break;
            }
            case 3: {
                chronoUnit = ChronoUnit.MICROS;
                break;
            }
            case 4: {
                chronoUnit = ChronoUnit.MILLIS;
                break;
            }
            case 5: {
                chronoUnit = ChronoUnit.SECONDS;
                break;
            }
            case 6: {
                chronoUnit = ChronoUnit.MINUTES;
                break;
            }
            case 7: {
                chronoUnit = ChronoUnit.HOURS;
                break;
            }
            case 8: {
                chronoUnit = ChronoUnit.HALF_DAYS;
                break;
            }
            case 9: {
                chronoUnit = ChronoUnit.DAYS;
                break;
            }
            case 10: {
                chronoUnit = ChronoUnit.WEEKS;
                break;
            }
            case 11: {
                chronoUnit = ChronoUnit.YEARS;
                break;
            }
            case 12: {
                chronoUnit = ChronoUnit.DECADES;
                break;
            }
            case 13: {
                chronoUnit = ChronoUnit.CENTURIES;
                break;
            }
            case 14: {
                chronoUnit = ChronoUnit.MILLENNIA;
                break;
            }
            case 15: {
                chronoUnit = ChronoUnit.FOREVER;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return chronoUnit;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getCalendarUnit() {
        return this.calendarUnit;
    }

    private KhronoUnit(double max, double calendarUnit) {
        this.max = max;
        this.calendarUnit = calendarUnit;
    }

    /* synthetic */ KhronoUnit(String string2, int n, double d, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 1.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        this(d, d2);
    }

    public static KhronoUnit[] values() {
        return (KhronoUnit[])$VALUES.clone();
    }

    public static KhronoUnit valueOf(String string2) {
        return Enum.valueOf(KhronoUnit.class, string2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lbvanseg/kotlincommons/time/api/KhronoUnit$Companion;", "", "()V", "FOREVER_CONSTANT", "", "NEVER_CONSTANT", "kotlincommons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

