/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.util.command.validator.impl;

import bvanseg.kotlincommons.util.command.validator.ValidationError;
import bvanseg.kotlincommons.util.command.validator.Validator;
import bvanseg.kotlincommons.util.command.validator.impl.ClampFloat;
import bvanseg.kotlincommons.util.comparable.ComparableUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001d\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lbvanseg/kotlincommons/util/command/validator/impl/ClampFloatValidator;", "Lbvanseg/kotlincommons/util/command/validator/Validator;", "Lbvanseg/kotlincommons/util/command/validator/impl/ClampFloat;", "", "()V", "createError", "Lbvanseg/kotlincommons/util/command/validator/ValidationError;", "annotation", "value", "mutate", "(Lbvanseg/kotlincommons/util/command/validator/impl/ClampFloat;F)Ljava/lang/Float;", "validate", "", "kotlincommons"})
public final class ClampFloatValidator
extends Validator<ClampFloat, Float> {
    @NotNull
    public static final ClampFloatValidator INSTANCE;

    @Override
    @NotNull
    public Float mutate(@NotNull ClampFloat annotation, float value) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return (Float)ComparableUtilsKt.clamp((Comparable)Float.valueOf(value), (Comparable)Float.valueOf(annotation.min()), (Comparable)Float.valueOf(annotation.max()));
    }

    @Override
    public boolean validate(@NotNull ClampFloat annotation, float value) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return value >= annotation.min() && value <= annotation.max();
    }

    @Override
    @NotNull
    public ValidationError createError(@NotNull ClampFloat annotation, float value) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return new ValidationError("Value " + value + " does not fall within the range of " + annotation.min() + " to " + annotation.max() + '.');
    }

    private ClampFloatValidator() {
        super(ClampFloat.class);
    }

    static {
        ClampFloatValidator clampFloatValidator;
        INSTANCE = clampFloatValidator = new ClampFloatValidator();
    }
}

