/*
 * Decompiled with CFR 0.152.
 */
package bvanseg.kotlincommons.util.compression;

import java.io.ByteArrayOutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"compress", "", "data", "bufferSize", "", "decompress", "kotlincommons"})
public final class CompressionUtilsKt {
    @NotNull
    public static final byte[] compress(@NotNull byte[] data, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[bufferSize];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    public static /* synthetic */ byte[] compress$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20000;
        }
        return CompressionUtilsKt.compress(byArray, n);
    }

    @NotNull
    public static final byte[] decompress(@NotNull byte[] data, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[bufferSize];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    public static /* synthetic */ byte[] decompress$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20000;
        }
        return CompressionUtilsKt.decompress(byArray, n);
    }
}

