/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j;

import com.bytegriffin.get4j.annotation.Redis;
import com.bytegriffin.get4j.annotation.Zookeeper;
import com.bytegriffin.get4j.conf.AbstractConfig;
import com.bytegriffin.get4j.conf.ClusterNode;
import com.bytegriffin.get4j.conf.ClusterNodeXmlHandler;
import com.bytegriffin.get4j.conf.Configuration;
import com.bytegriffin.get4j.conf.ConfigurationXmlHandler;
import com.bytegriffin.get4j.conf.Context;
import com.bytegriffin.get4j.conf.CoreSeedsXmlHandler;
import com.bytegriffin.get4j.conf.DefaultConfig;
import com.bytegriffin.get4j.conf.DynamicFieldXmlHandler;
import com.bytegriffin.get4j.conf.ResourceSync;
import com.bytegriffin.get4j.conf.ResourceSyncYamlHandler;
import com.bytegriffin.get4j.core.Initializer;
import com.bytegriffin.get4j.core.Process;
import com.bytegriffin.get4j.core.SpiderEngine;
import com.bytegriffin.get4j.core.WorkerStatusOpt;
import com.bytegriffin.get4j.ha.ProbeMasterElection;
import com.bytegriffin.get4j.ha.ZookeeperClient;
import com.bytegriffin.get4j.ha.ZookeeperOpt;
import com.bytegriffin.get4j.probe.ProbeMasterChecker;
import com.bytegriffin.get4j.store.HBaseStorage;
import com.bytegriffin.get4j.store.RedisStorage;
import com.bytegriffin.get4j.util.NetHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cluster {
    private static final Logger logger = LogManager.getLogger(Cluster.class);
    private static ClusterNode clusterNode;

    private Cluster() {
    }

    public static Cluster create() {
        clusterNode = new ClusterNode();
        return new Cluster();
    }

    public ClusterNode build() {
        if (Strings.isNullOrEmpty((String)clusterNode.getNodeName())) {
            clusterNode.setNodeName(NetHelper.getClusterNodeName());
        }
        if (Strings.isNullOrEmpty((String)clusterNode.getRedisAddress()) || Strings.isNullOrEmpty((String)clusterNode.getRedisMode()) || Strings.isNullOrEmpty((String)clusterNode.getRedisAuth())) {
            logger.error("\u6ca1\u6709\u8bbe\u7f6eredis\u5c5e\u6027...");
        }
        clusterNode.setInitializers(Cluster.buildInitializers(clusterNode));
        Cluster.setZookeeperOpt(clusterNode);
        return clusterNode;
    }

    public Cluster nodeName(String nodeName) {
        clusterNode.setNodeName(nodeName);
        return this;
    }

    public Cluster redis(String mode, String address, String auth) {
        clusterNode.setRedisMode(mode);
        clusterNode.setRedisAddress(address);
        clusterNode.setRedisAuth(auth);
        return this;
    }

    public Cluster zookeeper(String address) {
        clusterNode.setZookeeperAddress(address);
        return this;
    }

    public Cluster redis(Class<?> clazz) {
        Annotation[] ans = clazz.getDeclaredAnnotations();
        if (ans == null || ans.length == 0) {
            logger.error("\u7c7b[{}]\u6ca1\u6709\u914d\u7f6e\u4efb\u4f55Annotation\u3002", (Object)clazz.getName());
            System.exit(1);
        }
        for (Annotation an : ans) {
            String type = an.annotationType().getSimpleName();
            if ("Redis".equalsIgnoreCase(type)) {
                if (!clazz.isAnnotationPresent(Redis.class)) continue;
                Redis redis = clazz.getAnnotation(Redis.class);
                this.redis(redis.mode(), redis.address(), redis.auth());
                continue;
            }
            if (!"Zookeeper".equalsIgnoreCase(type) || !clazz.isAnnotationPresent(Zookeeper.class)) continue;
            Zookeeper zookeeper = clazz.getAnnotation(Zookeeper.class);
            this.zookeeper(zookeeper.value());
        }
        return this;
    }

    public Cluster enableHBase() {
        clusterNode.setHbase(Cluster.buildHBase());
        return this;
    }

    private static List<Initializer> buildInitializers(ClusterNode node) {
        RedisStorage redis = null;
        ArrayList inits = Lists.newArrayList();
        if (!(Strings.isNullOrEmpty((String)node.getRedisMode()) || Strings.isNullOrEmpty((String)node.getRedisAddress()) || Strings.isNullOrEmpty((String)node.getRedisAuth()))) {
            redis = new RedisStorage(node.getRedisMode(), node.getRedisAddress(), node.getRedisAuth());
            inits.add(redis);
        }
        ZookeeperClient zk = null;
        if (!Strings.isNullOrEmpty((String)node.getZookeeperAddress())) {
            zk = new ZookeeperClient(node.getZookeeperAddress());
            inits.add(zk);
        }
        return inits;
    }

    private static WorkerStatusOpt buildWorkerStatusOpt() {
        return ZookeeperOpt.single();
    }

    private static ProbeMasterChecker buildProbeMasterChecker() {
        return ProbeMasterElection.single();
    }

    private static void setZookeeperOpt(ClusterNode clusterNode) {
        if (!Strings.isNullOrEmpty((String)clusterNode.getZookeeperAddress())) {
            clusterNode.setWorkerStatusOpt(Cluster.buildWorkerStatusOpt());
            clusterNode.setProbeMasterChecker(Cluster.buildProbeMasterChecker());
        }
    }

    private static Process buildHBase() {
        return new HBaseStorage();
    }

    public static void main(String[] args) {
        DefaultConfig.closeHttpClientLog();
        Context context = new Context((AbstractConfig)new CoreSeedsXmlHandler());
        List seeds = (List)context.load();
        context = new Context((AbstractConfig)new ResourceSyncYamlHandler());
        ResourceSync resourceSync = (ResourceSync)context.load();
        context = new Context((AbstractConfig)new ConfigurationXmlHandler());
        Configuration configuration = (Configuration)context.load();
        context = new Context((AbstractConfig)new DynamicFieldXmlHandler());
        List dynamicFields = (List)context.load();
        context = new Context((AbstractConfig)new ClusterNodeXmlHandler());
        ClusterNode clusterNode = (ClusterNode)context.load();
        clusterNode.setInitializers(Cluster.buildInitializers(clusterNode));
        Cluster.setZookeeperOpt(clusterNode);
        SpiderEngine.create().setClusterNode(clusterNode).addHBase(Cluster.buildHBase()).setSeeds(seeds).setResourceSync(resourceSync).setConfiguration(configuration).setDynamicFields(dynamicFields).build();
        logger.info("\u722c\u866b\u96c6\u7fa4\u5f00\u59cb\u542f\u52a8...");
    }
}

