/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.conf;

import com.bytegriffin.get4j.conf.AbstractConfig;
import com.bytegriffin.get4j.conf.ClusterNode;
import com.bytegriffin.get4j.conf.XmlHelper;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class ClusterNodeXmlHandler
extends AbstractConfig {
    private static Logger logger = LogManager.getLogger(ClusterNodeXmlHandler.class);
    private static final String cluster_node_xml_file = conf_path + "cluster-node.xml";
    private static final String cluster_node_xsd_file = conf_path + "cluster-node.xsd";
    private static final String redis_mode = "fetch.redis.mode";
    private static final String redis_address = "fetch.redis.address";
    private static final String redis_auth = "fetch.redis.auth";
    private static final String zookeeper_address = "ha.zookeeper.quorum";

    public ClusterNode load() {
        XmlHelper.validate((String)cluster_node_xml_file, (String)cluster_node_xsd_file);
        logger.info("\u6b63\u5728\u8bfb\u53d6xml\u914d\u7f6e\u6587\u4ef6[" + cluster_node_xml_file + "]......");
        Document doc = XmlHelper.loadXML((String)cluster_node_xml_file);
        if (doc == null) {
            return null;
        }
        Element root = doc.getRootElement();
        if (root == null) {
            return null;
        }
        List propElements = root.elements("property");
        ClusterNode conf = new ClusterNode();
        for (Element property : propElements) {
            if (property == null) continue;
            String name = property.element("name").getStringValue();
            String value = property.element("value").getStringValue();
            if (name.equalsIgnoreCase("node.name")) {
                conf.setNodeName(value);
                continue;
            }
            if (name.equalsIgnoreCase(redis_mode)) {
                conf.setRedisMode(value);
                continue;
            }
            if (name.equalsIgnoreCase(redis_address)) {
                conf.setRedisAddress(value);
                continue;
            }
            if (name.equalsIgnoreCase(redis_auth)) {
                conf.setRedisAuth(value);
                continue;
            }
            if (!name.equalsIgnoreCase(zookeeper_address)) continue;
            conf.setZookeeperAddress(value);
        }
        return conf;
    }
}

