/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.ha;

import com.bytegriffin.get4j.probe.ProbeMasterChecker;
import com.bytegriffin.get4j.util.NetHelper;
import com.bytegriffin.get4j.util.Sleep;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProbeMasterElection
extends LeaderSelectorListenerAdapter
implements ProbeMasterChecker {
    private static final Logger logger = LogManager.getLogger(ProbeMasterElection.class);
    private static final ProbeMasterElection me = new ProbeMasterElection();
    private static final String zk_probe_path_prefix = "/probe/";
    private LeaderSelector leaderSelector;
    private String seedName;
    private static Map<String, ProbeMasterElection> probe_master_map = Maps.newHashMap();
    private static Map<String, LeaderSelector> leader_selector_map = Maps.newHashMap();

    private ProbeMasterElection() {
    }

    public static ProbeMasterElection single() {
        return me;
    }

    static ProbeMasterElection create(CuratorFramework client, String seedName) {
        ProbeMasterElection pms = new ProbeMasterElection(client, seedName);
        probe_master_map.put(seedName, pms);
        return pms;
    }

    static boolean checkMaster(String seedName) {
        ProbeMasterElection pms = probe_master_map.get(seedName);
        if (pms == null) {
            return false;
        }
        return pms.isActive(seedName);
    }

    private ProbeMasterElection(CuratorFramework client, String seedName) {
        this.seedName = seedName;
        this.leaderSelector = new LeaderSelector(client, zk_probe_path_prefix + seedName, (LeaderSelectorListener)this);
        this.leaderSelector.autoRequeue();
        this.leaderSelector.start();
        leader_selector_map.put(seedName, this.leaderSelector);
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        logger.info("\u79cd\u5b50[{}]\u96c6\u7fa4\u4e2d\u5c06\u8282\u70b9[{}]\u88ab\u9009\u4e3e\u4e3aProbe Master\u3002", (Object)this.seedName, (Object)NetHelper.getClusterNodeName());
        while (true) {
            Sleep.seconds((long)Integer.MAX_VALUE);
        }
    }

    public boolean isActive(String seedName) {
        return leader_selector_map.get(seedName).hasLeadership();
    }
}

