/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.ha;

import com.bytegriffin.get4j.conf.Seed;
import com.bytegriffin.get4j.core.Globals;
import com.bytegriffin.get4j.core.Initializer;
import com.bytegriffin.get4j.core.SpiderEngine;
import com.bytegriffin.get4j.core.WorkerStatusOpt;
import com.bytegriffin.get4j.ha.ProbeMasterElection;
import com.bytegriffin.get4j.ha.ZookeeperOpt;
import com.bytegriffin.get4j.probe.PageChangeProber;
import com.bytegriffin.get4j.util.NetHelper;
import com.bytegriffin.get4j.util.Sleep;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZookeeperClient
extends Initializer {
    private static final Logger logger = LogManager.getLogger(ZookeeperClient.class);
    private static final int seesion_timeout = 3000;
    private static final int connection_timeout = 3000;
    private static final String namespace = "get4j";
    public static CuratorFramework client;
    private String address;

    public ZookeeperClient(String address) {
        this.address = address;
    }

    public void init() {
        client = CuratorFrameworkFactory.builder().connectString(this.address).sessionTimeoutMs(3000).connectionTimeoutMs(3000).canBeReadOnly(true).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).namespace(namespace).defaultData(null).build();
        client.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState state) {
                switch (state) {
                    case LOST: 
                    case SUSPENDED: {
                        logger.error("\u8fde\u63a5zookeeper\u4e22\u5931\u3002");
                        break;
                    }
                    case RECONNECTED: {
                        logger.info("\u91cd\u65b0\u8fde\u63a5zookeeper\u3002");
                        break;
                    }
                }
            }
        });
        client.start();
        try {
            if (!client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                logger.error("\u8fde\u63a5zookeeper\u5931\u8d25\u3002");
                System.exit(1);
            } else {
                logger.info("\u8fde\u63a5zookeeper\u6210\u529f\u3002");
            }
        }
        catch (InterruptedException e) {
            logger.error("\u8fde\u63a5zookeeper\u5931\u8d25{}", (Throwable)e);
        }
        try {
            int size = Globals.CHAIN_CACHE.size();
            if (size > 0) {
                for (String seedName : Globals.CHAIN_CACHE.keySet()) {
                    Stat stat = (Stat)client.checkExists().forPath(ZookeeperOpt.getStatusNodeName(seedName));
                    if (stat == null) {
                        ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(ZookeeperOpt.getStatusNodeName(seedName), "idle".getBytes());
                    }
                    ZookeeperClient.watchNodeStatus(seedName);
                    ProbeMasterElection.create(client, seedName);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efazookeeper\u8282\u70b9\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void watchNodeStatus(final String seedName) {
        try {
            TreeCache node = new TreeCache(client, ZookeeperOpt.getStatusNodeName(seedName));
            node.getListenable().addListener((Object)new TreeCacheListener(){
                private AtomicBoolean isFirstRun = new AtomicBoolean(true);

                public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                    String nodePath = "";
                    String nodeValue = "";
                    if (event.getData() != null) {
                        nodePath = event.getData().getPath();
                        nodeValue = new String(event.getData().getData());
                    }
                    switch (event.getType()) {
                        case NODE_ADDED: {
                            logger.info("Zookeeper\u53d1\u73b0\u4e00\u4e2a\u65b0\u7684\u8282\u70b9[{}]\u8fde\u63a5\u8fdb\u6765\uff0c\u5176\u72b6\u6001\u4e3a[{}]\u3002", (Object)NetHelper.getClusterNodeName(), (Object)nodeValue);
                            if (this.isFirstRun.get() || !"run".equals(nodeValue)) break;
                            logger.info("Zookeeper\u53d1\u73b0\u5728\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0b\u7684\u8def\u5f84\u4e3a[{}]\u6709\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff0c\u5e76\u4e14\u5c06\u6b64\u4efb\u52a1\u5206\u914d\u7ed9\u65b0\u52a0\u5165\u72b6\u6001\u4e3a[{}]\u7684\u8282\u70b9[{}]\u3002", (Object)seedName, (Object)nodePath, (Object)nodeValue, (Object)NetHelper.getClusterNodeName());
                            SpiderEngine.create().startUp((Seed)Globals.SEED_CACHE.get(seedName), (WorkerStatusOpt)ZookeeperOpt.single(), ProbeMasterElection.checkMaster(seedName));
                            break;
                        }
                        case NODE_UPDATED: {
                            if (!this.isFirstRun.get() && "run".equals(nodeValue)) {
                                logger.info("Zookeeper\u53d1\u73b0\u5728\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0b\u7684\u8def\u5f84\u4e3a[{}]\u6709\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\uff0c\u5e76\u4e14\u5c06\u6b64\u4efb\u52a1\u5206\u914d\u7ed9\u72b6\u6001\u4e3a[{}]\u7684\u8282\u70b9[{}]\u3002", (Object)seedName, (Object)nodePath, (Object)nodeValue, (Object)NetHelper.getClusterNodeName());
                                SpiderEngine.create().startUp((Seed)Globals.SEED_CACHE.get(seedName), (WorkerStatusOpt)ZookeeperOpt.single(), ProbeMasterElection.checkMaster(seedName));
                            }
                            this.isFirstRun.set(false);
                            logger.info("Zookeeper\u5c06\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0b\u7684\u8def\u5f84\u4e3a[{}]\u4e00\u4e2a\u8282\u70b9[{}]\u7684\u72b6\u6001\u66f4\u65b0\u4e3a[{}]\u3002", (Object)seedName, (Object)nodePath, (Object)NetHelper.getClusterNodeName(), (Object)nodeValue);
                            break;
                        }
                        case NODE_REMOVED: 
                        case CONNECTION_LOST: {
                            logger.warn("Zookeeper\u53d1\u73b0\u5c06\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0b\u7684\u8def\u5f84\u4e3a[{}]\u6709\u4e00\u4e2a\u72b6\u6001\u4e3a[{}]\u8282\u70b9\u9000\u51fa\u3002", (Object)seedName, (Object)nodePath, (Object)nodeValue, (Object)NetHelper.getClusterNodeName());
                            PageChangeProber probe = (PageChangeProber)Globals.FETCH_PROBE_CACHE.get(seedName);
                            if (probe == null) break;
                            ProbeMasterElection.checkMaster(seedName);
                            Sleep.seconds((long)3L);
                            boolean isProbeMaster = ProbeMasterElection.checkMaster(seedName);
                            if (!isProbeMaster) break;
                            SpiderEngine.create().startUp((Seed)Globals.SEED_CACHE.get(seedName), (WorkerStatusOpt)ZookeeperOpt.single(), isProbeMaster);
                            logger.warn("Zookeeper\u53d1\u73b0\u5c06\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0b\u7684\u8def\u5f84\u4e3a[{}]\u6709\u4e00\u4e2a\u72b6\u6001\u4e3a[{}]\u5ba2\u6237\u7aef[{}]\u9000\u51fa\u3002", (Object)seedName, (Object)nodePath, (Object)nodeValue, (Object)NetHelper.getClusterNodeName());
                            break;
                        }
                    }
                }
            });
            node.start();
        }
        catch (Exception e) {
            logger.error("\u76d1\u63a7\u79cd\u5b50[{}]\u96c6\u7fa4\u4e0bzookeeper\u7684\u8282\u70b9\u5931\u8d25\uff1a", (Object)seedName, (Object)e);
        }
    }
}

