/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.ha;

import com.bytegriffin.get4j.core.WorkerStatusOpt;
import com.bytegriffin.get4j.ha.ZookeeperClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZookeeperOpt
implements WorkerStatusOpt {
    private static final Logger logger = LogManager.getLogger(ZookeeperOpt.class);
    private static final String status_path = "status";
    static final String seed_run_status = "run";
    static final String seed_idle_status = "idle";
    private static final ZookeeperOpt zkopt = new ZookeeperOpt();

    private ZookeeperOpt() {
    }

    public static ZookeeperOpt single() {
        return zkopt;
    }

    public static String getStatusNodeName(String seedName) {
        return "/status/" + seedName;
    }

    public synchronized void setIdleStatus(String seedName) {
        String nodeName = ZookeeperOpt.getStatusNodeName(seedName);
        try {
            String status = new String((byte[])ZookeeperClient.client.getData().forPath(nodeName));
            if (seed_run_status.equals(status)) {
                ZookeeperClient.client.setData().forPath(nodeName, seed_idle_status.getBytes());
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539zookeeper\u8282\u70b9[{}]\u5931\u8d25{}", (Object)nodeName, (Object)e);
        }
    }

    public synchronized void setRunStatus(String seedName) {
        String nodeName = ZookeeperOpt.getStatusNodeName(seedName);
        try {
            String status = new String((byte[])ZookeeperClient.client.getData().forPath(nodeName));
            if (seed_idle_status.equals(status)) {
                ZookeeperClient.client.setData().forPath(nodeName, seed_run_status.getBytes());
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539zookeeper\u8282\u70b9[{}]\u5931\u8d25{}", (Object)nodeName, (Object)e);
        }
    }
}

