/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.store;

import com.bytegriffin.get4j.conf.Seed;
import com.bytegriffin.get4j.core.Page;
import com.bytegriffin.get4j.core.Process;
import com.bytegriffin.get4j.util.DateUtil;
import com.bytegriffin.get4j.util.MD5Util;
import com.google.common.base.Strings;
import java.util.Map;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HBaseStorage
implements Process {
    private static final Logger logger = LogManager.getLogger(HBaseStorage.class);
    private static final String namespace = "get4j";
    private static final String tableName = "get4j:page";
    private static final String columnFamily = "cf";
    private static Map<String, Table> tables = Maps.newHashMap();

    public void init(Seed seed) {
        Configuration configuration = HBaseConfiguration.create();
        configuration.set("hbase.zookeeper.quorum", seed.getStoreHBase());
        try {
            NamespaceDescriptor[] nsArray;
            Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
            Admin admin = connection.getAdmin();
            TableName tName = TableName.valueOf((String)tableName);
            boolean isExist = false;
            for (NamespaceDescriptor ns : nsArray = admin.listNamespaceDescriptors()) {
                if (!namespace.equalsIgnoreCase(ns.getName())) continue;
                isExist = true;
                break;
            }
            if (!isExist) {
                admin.createNamespace(NamespaceDescriptor.create((String)namespace).build());
            }
            if (!admin.tableExists(tName)) {
                HTableDescriptor tableDescriptor = new HTableDescriptor(tName);
                tableDescriptor.setDurability(Durability.ASYNC_WAL);
                tableDescriptor.addFamily(new HColumnDescriptor(columnFamily));
                admin.createTable(tableDescriptor);
            }
            Table table = connection.getTable(TableName.valueOf((String)tableName));
            tables.put(seed.getSeedName(), table);
            admin.close();
        }
        catch (Exception e) {
            logger.error("\u79cd\u5b50[{}]\u7684\u7ec4\u4ef6HBaseStorage\u7684\u521d\u59cb\u5316\u51fa\u9519\u3002", (Object)seed.getSeedName(), (Object)e);
        }
        logger.info("\u79cd\u5b50[{}]\u7684\u7ec4\u4ef6HBaseStorage\u7684\u521d\u59cb\u5316\u5b8c\u6210\u3002", (Object)seed.getSeedName());
    }

    public void execute(Page page) {
        Table table = tables.get(page.getSeedName());
        this.insertOrUpdate(table, page);
        logger.info("\u7ebf\u7a0b[{}]\u4fdd\u5b58\u79cd\u5b50[{}]url\u4e3a[{}]\u5230HBase\u6570\u636e\u5e93\u4e2d\u3002", (Object)Thread.currentThread().getName(), (Object)page.getSeedName(), (Object)page.getUrl());
    }

    public void insertOrUpdate(Table table, Page page) {
        try {
            Put put = new Put(Bytes.toBytes((String)MD5Util.convert((String)page.getUrl())));
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"SEED_NAME"), Bytes.toBytes((String)page.getSeedName()));
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"FETCH_URL"), Bytes.toBytes((String)page.getUrl()));
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"SITE_HOST"), Bytes.toBytes((String)page.getHost()));
            if (!Strings.isNullOrEmpty((String)page.getTitle())) {
                put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"TITLE"), Bytes.toBytes((String)page.getTitle()));
            }
            if (!Strings.isNullOrEmpty((String)page.getAvatar())) {
                put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"AVATAR"), Bytes.toBytes((String)page.getAvatar()));
            }
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"FETCH_CONTENT"), Bytes.toBytes((String)page.getContent()));
            if (!Strings.isNullOrEmpty((String)page.getCookies())) {
                put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"COOKIES"), Bytes.toBytes((String)page.getCookies()));
            }
            if (!page.getResources().isEmpty()) {
                put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"RESOURCES_URL"), Bytes.toBytes((String)page.getResources().toString()));
            }
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"FETCH_TIME"), Bytes.toBytes((String)page.getFetchTime()));
            put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)"CREATE_TIME"), Bytes.toBytes((String)DateUtil.getCurrentDate()));
            for (int i = 1; i <= page.getFields().size(); ++i) {
                put.addColumn(Bytes.toBytes((String)columnFamily), Bytes.toBytes((String)("FIELD" + i)), Bytes.toBytes((String)page.getFields().get(i).toString()));
            }
            table.put(put);
        }
        catch (Exception e) {
            logger.error("\u79cd\u5b50[{}]\u5728\u8fdb\u884c\u63d2\u5165\u6570\u636e\u65f6\u51fa\u9519\u3002", (Object)page.getSeedName(), (Object)e);
        }
    }
}

