/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.store;

import com.bytegriffin.get4j.store.RedisStorage;
import com.bytegriffin.get4j.util.Queue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import redis.clients.jedis.JedisCommands;

public class RedisQueue<E>
implements Queue<E> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private LinkedList<E> list = Lists.newLinkedList();
    private final Map<String, Integer> score_map = Maps.newHashMap();

    public void add(E e) {
        this.writeLock.lock();
        try {
            if (!this.contains(e)) {
                this.list.add(e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, E e) {
        this.writeLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            if (!this.contains(e)) {
                int count = 0;
                if (this.score_map.containsKey(key)) {
                    count = this.score_map.get(key) + 1;
                }
                jedis.zadd(key, (double)count, (String)e);
                this.score_map.put(key, count);
            }
        }
        finally {
            RedisStorage.close(jedis);
            this.writeLock.unlock();
        }
    }

    public E get(int index) {
        this.readLock.lock();
        try {
            E e = this.list.get(index);
            return e;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(String queueName, int index) {
        this.readLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            Set set = jedis.zrange(queueName, 0L, (long)index);
            if (set == null || set.isEmpty()) {
                E e = null;
                return e;
            }
            Object e = set.iterator().next();
            return e;
        }
        finally {
            RedisStorage.close(jedis);
            this.readLock.unlock();
        }
    }

    public long size() {
        this.readLock.lock();
        try {
            long l = this.list.size();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String queueName) {
        this.readLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            long l = jedis.zcard(queueName);
            return l;
        }
        finally {
            RedisStorage.close(jedis);
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.list.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear(String queueName) {
        this.writeLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            this.list.clear();
            jedis.zremrangeByRank(queueName, 0L, -1L);
        }
        finally {
            RedisStorage.close(jedis);
            this.writeLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.writeLock.lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String queueName) {
        this.writeLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            boolean bl = jedis.exists(queueName) == false;
            return bl;
        }
        finally {
            RedisStorage.close(jedis);
            this.writeLock.unlock();
        }
    }

    public E outFirst() {
        this.writeLock.lock();
        try {
            if (!this.list.isEmpty()) {
                E e = this.list.removeFirst();
                return e;
            }
            E e = null;
            return e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E outFirst(String queueName) {
        this.writeLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            Set url = jedis.zrange(queueName, 0L, 0L);
            long count = 0L;
            if (url != null && url.size() > 0) {
                count = jedis.zremrangeByRank(queueName, 0L, 0L);
            }
            if (count == 1L) {
                Object e = url.iterator().next();
                return e;
            }
            E e = null;
            return e;
        }
        finally {
            RedisStorage.close(jedis);
            this.writeLock.unlock();
        }
    }

    public boolean contains(E e) {
        this.readLock.lock();
        try {
            boolean bl = this.list.contains(e);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String queueName, E e) {
        this.readLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            Long count = jedis.zrank(queueName, (String)e);
            if (count != null && count > 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RedisStorage.close(jedis);
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<E> getQueue(String queueName) {
        this.writeLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            Set set = jedis.zrange(queueName, 0L, -1L);
            RedisQueue<E> queue = new RedisQueue<E>();
            queue.list.clear();
            for (String str : set) {
                queue.list.add(str);
            }
            RedisQueue<E> redisQueue = queue;
            return redisQueue;
        }
        finally {
            RedisStorage.close(jedis);
            this.writeLock.unlock();
        }
    }

    public LinkedList<E> getAll() {
        this.readLock.lock();
        try {
            LinkedList<E> linkedList = this.list;
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<E> getAll(String queueName) {
        this.readLock.lock();
        JedisCommands jedis = RedisStorage.newJedis();
        try {
            Set set = jedis.zrange(queueName, 0L, -1L);
            return set;
        }
        finally {
            RedisStorage.close(jedis);
            this.readLock.unlock();
        }
    }
}

