/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.store;

import com.bytegriffin.get4j.core.Initializer;
import com.bytegriffin.get4j.core.UrlQueue;
import com.bytegriffin.get4j.store.RedisQueue;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisStorage
extends Initializer {
    private static final Logger logger = LogManager.getLogger(RedisStorage.class);
    private static final String host_split = ",";
    private static final int default_port = 6379;
    private static RedisStorage redisStorage;
    private JedisPool jedisPool;
    private ShardedJedisPool shardedJedisPool;
    private Set<HostAndPort> clusterNodes;
    private String redisMode;
    private String redisAddress;
    private String redisAuth;

    public RedisStorage(String redisMode, String redisAddress, String redisAuth) {
        this.redisMode = redisMode;
        this.redisAddress = redisAddress;
        this.redisAuth = redisAuth;
        redisStorage = this;
    }

    public void init() {
        if (Strings.isNullOrEmpty((String)this.redisMode) || Strings.isNullOrEmpty((String)this.redisAddress) || Strings.isNullOrEmpty((String)this.redisAuth)) {
            logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u5728\u521d\u59cb\u5316\u65f6\u53c2\u6570\u4e3a\u7a7a\u3002");
            System.exit(1);
        }
        if ("one".equalsIgnoreCase(this.redisMode)) {
            this.one(this.redisAddress, this.redisAuth);
        } else if ("sharded".equalsIgnoreCase(this.redisMode)) {
            this.shard(this.redisAddress, this.redisAuth);
        } else if ("cluster".equalsIgnoreCase(this.redisMode)) {
            this.cluster(this.redisAddress, this.redisAuth);
        }
        UrlQueue.registerRedisQueue(new RedisQueue());
        logger.info("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u7684\u521d\u59cb\u5316\u5b8c\u6210\u3002");
    }

    private static JedisPoolConfig config() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(1000);
        config.setMaxIdle(5);
        config.setMinIdle(1);
        config.setBlockWhenExhausted(true);
        config.setMaxWaitMillis(60000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(60000L);
        return config;
    }

    public static JedisCommands newJedis() {
        return RedisStorage.getConnection();
    }

    public static void close(JedisCommands jedis) {
        if ("one".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            Jedis one = (Jedis)jedis;
            if (one != null) {
                one.close();
            }
        } else if ("sharded".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            ShardedJedis sharedJedis = (ShardedJedis)jedis;
            if (sharedJedis != null) {
                sharedJedis.close();
            }
        } else if ("cluster".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            try {
                JedisCluster jedisCluster = (JedisCluster)jedis;
                if (jedisCluster != null) {
                    jedisCluster.close();
                }
            }
            catch (IOException e) {
                logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u5173\u95ed\u94fe\u63a5\u5931\u8d25\u3002", (Throwable)e);
            }
        }
    }

    private static synchronized JedisCommands getConnection() {
        Jedis jedis = null;
        if ("one".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            Jedis one = null;
            try {
                jedis = one = RedisStorage.redisStorage.jedisPool.getResource();
            }
            catch (Exception e) {
                logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u521d\u59cb\u5316\u94fe\u63a5\u5931\u8d25\u3002", (Throwable)e);
                System.exit(1);
            }
        } else if ("sharded".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            ShardedJedis sharedJedis = null;
            try {
                sharedJedis = RedisStorage.redisStorage.shardedJedisPool.getResource();
                jedis = sharedJedis;
            }
            catch (Exception e) {
                logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u521d\u59cb\u5316\u94fe\u63a5\u5931\u8d25\u3002", (Throwable)e);
                System.exit(1);
            }
        } else if ("cluster".equalsIgnoreCase(RedisStorage.redisStorage.redisMode)) {
            JedisCluster jedisCluster = null;
            try {
                jedisCluster = Strings.isNullOrEmpty((String)RedisStorage.redisStorage.redisAuth) ? new JedisCluster(RedisStorage.redisStorage.clusterNodes, 2000, 2000, 5, (GenericObjectPoolConfig)RedisStorage.config()) : new JedisCluster(RedisStorage.redisStorage.clusterNodes, 2000, 2000, 5, RedisStorage.redisStorage.redisAuth, (GenericObjectPoolConfig)RedisStorage.config());
                jedis = jedisCluster;
            }
            catch (Exception e) {
                logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u521d\u59cb\u5316\u94fe\u63a5\u5931\u8d25\u3002", (Throwable)e);
                System.exit(1);
            }
        }
        return jedis;
    }

    public void one(String address, String password) {
        String firstAddress = (String)Splitter.on((String)host_split).trimResults().split((CharSequence)address).iterator().next();
        List list = Splitter.on((String)":").trimResults().splitToList((CharSequence)firstAddress);
        String host = "";
        Integer port = null;
        if (list.size() == 1) {
            host = Strings.isNullOrEmpty((String)((String)list.get(0))) ? null : (String)list.get(0);
            port = 6379;
        } else if (list.size() == 2) {
            host = Strings.isNullOrEmpty((String)((String)list.get(0))) ? null : (String)list.get(0);
            port = Strings.isNullOrEmpty((String)((String)list.get(1))) ? null : Integer.valueOf((String)list.get(1));
        } else {
            logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0redis\u5730\u5740\u683c\u5f0f\u6709\u95ee\u9898\uff1a{}", (Object)address);
            System.exit(1);
        }
        this.jedisPool = Strings.isNullOrEmpty((String)password) ? new JedisPool((GenericObjectPoolConfig)RedisStorage.config(), host, port.intValue()) : new JedisPool((GenericObjectPoolConfig)RedisStorage.config(), host, port.intValue(), 2000, password);
    }

    public void shard(String addresses, String password) {
        List list = Splitter.on((String)host_split).trimResults().splitToList((CharSequence)addresses);
        ArrayList shards = Lists.newArrayList();
        for (String addr : list) {
            JedisShardInfo node;
            List hostAndPort = Splitter.on((String)":").trimResults().splitToList((CharSequence)addr);
            if (hostAndPort.size() == 1) {
                node = new JedisShardInfo((String)hostAndPort.get(0), 6379);
                if (!Strings.isNullOrEmpty((String)password)) {
                    node.setPassword(password);
                }
                shards.add(node);
                continue;
            }
            if (hostAndPort.size() != 2) continue;
            node = new JedisShardInfo((String)hostAndPort.get(0), Integer.valueOf((String)hostAndPort.get(1)).intValue());
            if (!Strings.isNullOrEmpty((String)password)) {
                node.setPassword(password);
            }
            shards.add(node);
        }
        if (shards == null || shards.isEmpty()) {
            logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0redis\u5730\u5740\u683c\u5f0f\u6709\u95ee\u9898\u3002");
            System.exit(1);
        }
        this.shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)RedisStorage.config(), (List)shards);
    }

    public void cluster(String addresses, String password) {
        List list = Splitter.on((String)host_split).trimResults().splitToList((CharSequence)addresses);
        this.clusterNodes = Sets.newHashSet();
        for (String addr : list) {
            List hostAndPort = Splitter.on((String)":").trimResults().splitToList((CharSequence)addr);
            if (hostAndPort.size() == 1) {
                this.clusterNodes.add(new HostAndPort((String)hostAndPort.get(0), 6379));
                continue;
            }
            if (hostAndPort.size() != 2) continue;
            this.clusterNodes.add(new HostAndPort((String)hostAndPort.get(0), Integer.valueOf((String)hostAndPort.get(1)).intValue()));
        }
        if (this.clusterNodes == null || this.clusterNodes.isEmpty()) {
            logger.error("Cluster\u6a21\u5f0f\u4e0b\u7684\u7ec4\u4ef6RedisStorage\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0redis\u5730\u5740\u683c\u5f0f\u6709\u95ee\u9898\u3002");
            System.exit(1);
        }
    }
}

