/*
 * Decompiled with CFR 0.152.
 */
package com.bytegriffin.get4j.util;

import com.bytegriffin.get4j.util.MD5Util;
import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NetHelper {
    private static final Logger logger = LogManager.getLogger(NetHelper.class);

    public static String getClusterNodeName() {
        try {
            return NetHelper.ip() + "@" + NetHelper.pid();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u96c6\u7fa4\u8282\u70b9\u540d\u79f0\u51fa\u73b0\u95ee\u9898\uff1a" + e);
            return MD5Util.generateSeedName();
        }
    }

    public static String ip() throws SocketException, UnknownHostException {
        String localIp = null;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.isUp()) continue;
            Enumeration<InetAddress> addressEnumeration = networkInterface.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                String ip = addressEnumeration.nextElement().getHostAddress();
                String REGX_IP = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
                if (!ip.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)") || ip.equals("127.0.0.1")) continue;
                localIp = ip;
            }
        }
        if (Strings.isNullOrEmpty(localIp)) {
            localIp = InetAddress.getLocalHost().getHostName();
        }
        return localIp;
    }

    private static String pid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return name.split("@")[0];
    }
}

