/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.elastic;

import com.hpe.caf.auditing.AuditChannel;
import com.hpe.caf.auditing.AuditConnection;
import com.hpe.caf.auditing.elastic.ElasticAuditChannel;
import com.hpe.caf.auditing.elastic.ElasticAuditIndexManager;
import com.hpe.caf.auditing.elastic.ElasticAuditTransportClientFactory;
import com.hpe.caf.auditing.exception.AuditConfigurationException;
import java.io.IOException;
import org.elasticsearch.client.transport.TransportClient;

public class ElasticAuditConnection
implements AuditConnection {
    private final TransportClient transportClient;
    private ElasticAuditIndexManager indexManager;

    public ElasticAuditConnection() throws AuditConfigurationException {
        String hostAndPorts = System.getProperty("CAF_ELASTIC_HOST_AND_PORT_VALUES", System.getenv("CAF_ELASTIC_HOST_AND_PORT_VALUES"));
        String clusterName = System.getProperty("CAF_ELASTIC_CLUSTER_NAME", System.getenv("CAF_ELASTIC_CLUSTER_NAME"));
        if (clusterName == null) {
            clusterName = "elasticsearch-cluster";
        }
        int numberOfShards = ElasticAuditConnection.getNumberFromSysPropertyOrEnvVariable("CAF_ELASTIC_NUMBER_OF_SHARDS", 5);
        int numberOfReplicas = ElasticAuditConnection.getNumberFromSysPropertyOrEnvVariable("CAF_ELASTIC_NUMBER_OF_REPLICAS", 1);
        this.transportClient = ElasticAuditTransportClientFactory.getTransportClient(hostAndPorts, clusterName);
        this.indexManager = new ElasticAuditIndexManager(numberOfShards, numberOfReplicas, this.transportClient);
    }

    private static int getNumberFromSysPropertyOrEnvVariable(String environmentVariable, int defaultTo) throws AuditConfigurationException {
        try {
            String envVarValue = System.getProperty(environmentVariable, System.getenv(environmentVariable));
            if (envVarValue != null) {
                return Integer.parseInt(envVarValue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new AuditConfigurationException(environmentVariable + " environment variable should only contain numbers", (Throwable)nfe);
        }
        return defaultTo;
    }

    public AuditChannel createChannel() throws IOException {
        return new ElasticAuditChannel(this.transportClient, this.indexManager);
    }

    public void close() throws Exception {
        this.transportClient.close();
        this.indexManager = null;
    }
}

