/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.elastic;

import com.hpe.caf.auditing.AuditCoreMetadataProvider;
import com.hpe.caf.auditing.AuditEventBuilder;
import com.hpe.caf.auditing.AuditIndexingHint;
import com.hpe.caf.auditing.elastic.ElasticAuditIndexManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.rest.RestStatus;

public class ElasticAuditEventBuilder
implements AuditEventBuilder {
    private static final Logger LOG = LogManager.getLogger((String)ElasticAuditEventBuilder.class.getName());
    private final TransportClient transportClient;
    private final ElasticAuditIndexManager indexManager;
    private String tenantId;
    private final Map<String, Object> auditEvent = new HashMap<String, Object>();

    public ElasticAuditEventBuilder(TransportClient transportClient, AuditCoreMetadataProvider coreMetadataProvider, ElasticAuditIndexManager indexManager) {
        this.transportClient = transportClient;
        this.indexManager = indexManager;
        this.addCommonFields(coreMetadataProvider);
    }

    private void addCommonFields(AuditCoreMetadataProvider coreMetadataProvider) {
        this.auditEvent.put("processId", coreMetadataProvider.getProcessId().toString());
        this.auditEvent.put("threadId", coreMetadataProvider.getThreadId());
        this.auditEvent.put("eventOrder", coreMetadataProvider.getEventOrder());
        this.auditEvent.put("eventTime", coreMetadataProvider.getEventTime().toString());
        this.auditEvent.put("eventTimeSource", coreMetadataProvider.getEventTimeSource());
    }

    public void setApplication(String applicationId) {
        this.auditEvent.put("applicationId", applicationId);
    }

    public void setUser(String userId) {
        this.auditEvent.put("userId", userId);
    }

    public void setTenant(String tenantId) {
        if (tenantId.contains(",")) {
            String errorMessage = "Invalid characters (i.e commas) in the tenant identifier: " + tenantId;
            LOG.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.tenantId = tenantId.toLowerCase();
        this.indexManager.getIndex(this.tenantId.concat("_audit"));
    }

    public void setCorrelationId(String correlationId) {
        this.auditEvent.put("correlationId", correlationId);
    }

    public void setEventType(String eventCategoryId, String eventTypeId) {
        this.auditEvent.put("eventCategoryId", eventCategoryId);
        this.auditEvent.put("eventTypeId", eventTypeId);
    }

    public void addEventParameter(String name, String columnName, String value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAKyw"), value);
    }

    public void addEventParameter(String name, String columnName, String value, AuditIndexingHint indexingHint) {
        if (indexingHint != null) {
            switch (indexingHint) {
                case KEYWORD: {
                    this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAKyw"), value);
                    break;
                }
                case FULLTEXT: {
                    this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CATxt"), value);
                    break;
                }
                default: {
                    String errorMessage = "Unexpected Elasticsearch indexing hint. Expected " + AuditIndexingHint.FULLTEXT + " or " + AuditIndexingHint.FULLTEXT + " but received '" + indexingHint.toString() + "'";
                    LOG.error(errorMessage);
                    throw new RuntimeException(errorMessage);
                }
            }
        } else {
            this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAKyw"), value);
        }
    }

    public void addEventParameter(String name, String columnName, short value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAShort"), value);
    }

    public void addEventParameter(String name, String columnName, int value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAInt"), value);
    }

    public void addEventParameter(String name, String columnName, long value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CALng"), value);
    }

    public void addEventParameter(String name, String columnName, float value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CAFlt"), Float.valueOf(value));
    }

    public void addEventParameter(String name, String columnName, double value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CADbl"), value);
    }

    public void addEventParameter(String name, String columnName, boolean value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CABln"), value);
    }

    public void addEventParameter(String name, String columnName, Date value) {
        this.auditEvent.put(ElasticAuditEventBuilder.getEventParamName(name, columnName).concat("_CADte"), value);
    }

    private static String getEventParamName(String name, String columnName) {
        return columnName == null ? name : columnName;
    }

    public void send() throws Exception {
        try {
            IndexResponse indexResponse = (IndexResponse)this.transportClient.prepareIndex(this.tenantId.concat("_audit"), "cafAuditEvent").setSource(this.auditEvent).get();
            RestStatus status = indexResponse.status();
            if (status != RestStatus.CREATED) {
                String errorMessage = "Unexpected Elasticsearch response status. Expected 'CREATED' but received '" + status.toString() + "'";
                LOG.error(errorMessage);
                throw new Exception(errorMessage);
            }
            LOG.debug("Audit event message successfully indexed in Elasticsearch. Index: " + indexResponse.getIndex() + ", Type: " + indexResponse.getType() + ", Id: " + indexResponse.getId());
        }
        catch (Exception e) {
            LOG.error("Error when indexing audit event message " + this.auditEvent.toString(), (Throwable)e);
            throw e;
        }
    }
}

