/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.elastic;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class ElasticAuditIndexManager {
    private static final Logger LOG = LogManager.getLogger((String)ElasticAuditIndexManager.class.getName());
    private final TransportClient transportClient;
    private final LoadingCache<String, String> indexCache;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private XContentBuilder cafAuditEventTenantIndexMappingsBuilder;

    public ElasticAuditIndexManager(int numberOfShards, int numberOfReplicas, TransportClient transportClient) {
        this.transportClient = transportClient;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.indexCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String indexName) {
                ElasticAuditIndexManager.this.createIndex(indexName);
                return indexName;
            }
        });
    }

    private XContentBuilder getTenantIndexTypeMappingsBuilder() {
        byte[] cafAuditEventTenantIndexMappingsBytes;
        try {
            cafAuditEventTenantIndexMappingsBytes = ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("CafAuditEventTenantIndexMappings.json"));
        }
        catch (IOException e) {
            String errorMessage = "Unable to read bytes from CafAuditEventTenantIndexMappings.json";
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
        try {
            XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, cafAuditEventTenantIndexMappingsBytes);
            parser.close();
            return XContentFactory.jsonBuilder().copyCurrentStructure(parser);
        }
        catch (IOException e) {
            String errorMessage = "Unable to parse JSON from CafAuditEventTenantIndexMappings.json";
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    public String getIndex(String indexName) {
        return (String)this.indexCache.getUnchecked((Object)indexName);
    }

    private void createIndex(String indexName) {
        String indexAlreadyExistsMessage = "Index " + indexName + " already exists";
        if (this.indexExists(indexName)) {
            LOG.debug(indexAlreadyExistsMessage);
            return;
        }
        LOG.debug("Creating a new index in Elasticsearch.");
        Settings indexSettings = Settings.builder().put("number_of_shards", this.numberOfShards).put("number_of_replicas", this.numberOfReplicas).build();
        CreateIndexRequest indexRequest = new CreateIndexRequest(indexName, indexSettings);
        if (this.cafAuditEventTenantIndexMappingsBuilder == null) {
            this.cafAuditEventTenantIndexMappingsBuilder = this.getTenantIndexTypeMappingsBuilder();
        }
        indexRequest.mapping("cafAuditEvent", this.cafAuditEventTenantIndexMappingsBuilder);
        try {
            if (((CreateIndexResponse)this.transportClient.admin().indices().create(indexRequest).actionGet()).isAcknowledged()) {
                LOG.debug("Index " + indexName + " has been created");
            } else if (!this.indexExists(indexName)) {
                String errorMessage = "Failed to create index " + indexName;
                LOG.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (ResourceAlreadyExistsException raee) {
            LOG.debug(indexAlreadyExistsMessage, (Throwable)raee);
        }
    }

    private boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.transportClient.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists();
    }
}

