/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.elastic;

public class ElasticAuditRetryOperation {
    public static final int DEFAULT_RETRIES = 5;
    public static final long DEFAULT_WAIT_TIME_MS = 1000L;
    private int numberOfRetries;
    private int numberOfTriesLeft;
    private long timeToWait;

    public ElasticAuditRetryOperation() {
        this(5, 1000L);
    }

    public ElasticAuditRetryOperation(int numberOfRetries, long timeToWait) {
        this.numberOfRetries = numberOfRetries;
        this.numberOfTriesLeft = numberOfRetries;
        this.timeToWait = timeToWait;
    }

    public boolean shouldRetry() {
        return this.numberOfTriesLeft > 0;
    }

    public void retryNeeded() throws Exception {
        --this.numberOfTriesLeft;
        if (!this.shouldRetry()) {
            throw new Exception("Retry Failed: Total " + this.numberOfRetries + " attempts made at interval " + this.getTimeToWait() + "ms");
        }
        this.waitUntilNextTry();
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    private void waitUntilNextTry() {
        try {
            Thread.sleep(this.getTimeToWait());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

