/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.elastic;

import com.hpe.caf.auditing.exception.AuditConfigurationException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class ElasticAuditTransportClientFactory {
    private static final Logger LOG = LogManager.getLogger((String)ElasticAuditTransportClientFactory.class.getName());
    private static final String ES_HOST_AND_PORT_NOT_PROVIDED = "Elasticsearch host and port have not been provided";
    private static final String ES_HOST_NOT_PROVIDED = "Elasticsearch host has not been provided";
    private static final String ES_PORT_NOT_PROVIDED = "Elasticsearch port has not been provided";

    private ElasticAuditTransportClientFactory() {
    }

    public static TransportClient getTransportClient(String hostAndPortValues, String clusterName) throws AuditConfigurationException {
        PreBuiltTransportClient transportClient;
        if (hostAndPortValues != null && !hostAndPortValues.isEmpty()) {
            String[] hostAndPortArray = hostAndPortValues.split(",");
            Settings.Builder settingsBuilder = Settings.builder().put("cluster.name", clusterName);
            if (hostAndPortArray.length > 1) {
                settingsBuilder.put("client.transport.sniff", true);
            }
            Settings settings = settingsBuilder.build();
            transportClient = new PreBuiltTransportClient(settings, new Class[0]);
            for (String hostAndPort : hostAndPortArray) {
                try {
                    URI uri = new URI("http://" + hostAndPort);
                    String host = uri.getHost();
                    int port = uri.getPort();
                    if (uri.getHost() == null) {
                        throw new URISyntaxException(uri.toString(), ES_HOST_NOT_PROVIDED);
                    }
                    if (uri.getPort() == -1) {
                        throw new URISyntaxException(uri.toString(), ES_PORT_NOT_PROVIDED);
                    }
                    try {
                        transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host), port));
                        LOG.debug("Elasticsearch initialization - added host: " + host);
                    }
                    catch (UnknownHostException e) {
                        LOG.error("Host unavailable or unknown: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error(e.getMessage());
                    throw new AuditConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (transportClient.listedNodes().isEmpty()) {
                String errorMessage = "Elasticsearch transport client is not configured to communicate with any nodes";
                LOG.error("Elasticsearch transport client is not configured to communicate with any nodes");
                throw new AuditConfigurationException("Elasticsearch transport client is not configured to communicate with any nodes");
            }
        } else {
            LOG.error(ES_HOST_AND_PORT_NOT_PROVIDED);
            throw new AuditConfigurationException(ES_HOST_AND_PORT_NOT_PROVIDED);
        }
        LOG.debug("Elasticsearch client initialized: " + transportClient.listedNodes().toString());
        return transportClient;
    }
}

