/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.webserviceclient;

import com.hpe.caf.auditing.AuditChannel;
import com.hpe.caf.auditing.AuditConnection;
import com.hpe.caf.auditing.exception.AuditConfigurationException;
import com.hpe.caf.auditing.webserviceclient.WebServiceClientAuditChannel;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebServiceClientAuditConnection
implements AuditConnection {
    private static final Logger LOG = LogManager.getLogger((String)WebServiceClientAuditConnection.class.getName());
    private static final String NO_PROXY = "NO_PROXY";
    private static final String HTTP_PROXY = "HTTP_PROXY";
    private static final String HTTPS_PROXY = "HTTPS_PROXY";
    private final Proxy httpProxy;
    private final URL webServiceEndpointUrl;

    public WebServiceClientAuditConnection() throws AuditConfigurationException {
        try {
            this.webServiceEndpointUrl = new URL(this.getWebServiceEndpointFullPath(System.getProperty("CAF_AUDIT_WEBSERVICE_ENDPOINT_URL", System.getenv("CAF_AUDIT_WEBSERVICE_ENDPOINT_URL"))));
        }
        catch (MalformedURLException mue) {
            String errorMessage = "Unable to create URL from Audit Web Service Endpoint configuration property";
            throw new AuditConfigurationException(errorMessage, (Throwable)mue);
        }
        this.httpProxy = this.getProxy(this.webServiceEndpointUrl);
    }

    private Proxy getProxy(URL webServiceEndpointUrl) throws AuditConfigurationException {
        String webserviceEndpointUrlProtocol = webServiceEndpointUrl.getProtocol();
        String noProxyList = this.getNoProxyList();
        if (noProxyList == null || !noProxyList.contains(webServiceEndpointUrl.getHost())) {
            String httpsProxy;
            LOG.debug(webServiceEndpointUrl.getHost() + " is not included in the list of no_proxy hosts. Attempting to create " + webserviceEndpointUrlProtocol.toUpperCase() + " proxy");
            if (webserviceEndpointUrlProtocol.equals("http")) {
                String httpProxy = this.getHttpProxy();
                if (httpProxy != null && !httpProxy.isEmpty()) {
                    URL httpProxyUrl;
                    try {
                        httpProxyUrl = new URL(httpProxy);
                    }
                    catch (MalformedURLException mue) {
                        String errorMessage = "Unable to create URL for HTTP Proxy: " + httpProxy;
                        throw new AuditConfigurationException(errorMessage, (Throwable)mue);
                    }
                    InetSocketAddress proxyInet = new InetSocketAddress(httpProxyUrl.getHost(), httpProxyUrl.getPort());
                    return new Proxy(Proxy.Type.HTTP, proxyInet);
                }
            } else if (webserviceEndpointUrlProtocol.equals("https") && (httpsProxy = this.getHttpsProxy()) != null && !httpsProxy.isEmpty()) {
                URL httpsProxyUrl;
                try {
                    httpsProxyUrl = new URL(httpsProxy);
                }
                catch (MalformedURLException mue) {
                    String errorMessage = "Unable to create URL for HTTPS Proxy: " + httpsProxy;
                    throw new AuditConfigurationException(errorMessage, (Throwable)mue);
                }
                InetSocketAddress proxyInet = new InetSocketAddress(httpsProxyUrl.getHost(), httpsProxyUrl.getPort());
                return new Proxy(Proxy.Type.HTTP, proxyInet);
            }
        }
        LOG.debug(webServiceEndpointUrl.getHost() + " is included in the list of no_proxy hosts or there are no HTTP or HTTPS proxies set to base one upon.");
        return null;
    }

    private String getWebServiceEndpointFullPath(String webServiceEndpoint) {
        if (webServiceEndpoint.endsWith("/")) {
            return webServiceEndpoint + "auditevents";
        }
        return webServiceEndpoint + "/auditevents";
    }

    private String getNoProxyList() {
        String noProxyList = System.getProperty(NO_PROXY, System.getenv(NO_PROXY));
        if (noProxyList == null) {
            noProxyList = System.getProperty(NO_PROXY.toLowerCase());
        }
        return noProxyList;
    }

    private String getHttpProxy() {
        String httpProxy = System.getProperty(HTTP_PROXY, System.getenv(HTTP_PROXY));
        if (httpProxy == null) {
            httpProxy = System.getProperty(HTTP_PROXY.toLowerCase());
        }
        return httpProxy;
    }

    private String getHttpsProxy() {
        String httpsProxy = System.getProperty(HTTPS_PROXY, System.getenv(HTTPS_PROXY));
        if (httpsProxy == null) {
            httpsProxy = System.getProperty(HTTPS_PROXY.toLowerCase());
        }
        return httpsProxy;
    }

    public AuditChannel createChannel() {
        return new WebServiceClientAuditChannel(this.webServiceEndpointUrl, this.httpProxy);
    }

    public void close() {
    }
}

