/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.auditing.webserviceclient;

import com.hpe.caf.auditing.AuditCoreMetadataProvider;
import com.hpe.caf.auditing.AuditEventBuilder;
import com.hpe.caf.auditing.AuditIndexingHint;
import com.hpe.caf.auditing.webserviceclient.WebServiceClientException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class WebServiceClientAuditEventBuilder
implements AuditEventBuilder {
    private static final Logger LOG = LogManager.getLogger((String)WebServiceClientAuditEventBuilder.class.getName());
    private static final String AUDIT_WS_CONN_TIMEOUT = "AUDIT_WS_CONN_TIMEOUT";
    private static int webServiceConnectionTimeout;
    private final Proxy httpProxy;
    private final URL webServiceEndpointUrl;
    private final Map<String, Object> auditEventCommonFields = new HashMap<String, Object>();
    private final List<EventParam> auditEventParams = new ArrayList<EventParam>();

    public WebServiceClientAuditEventBuilder(URL webServiceEndpointUrl, Proxy httpProxy, AuditCoreMetadataProvider coreMetadataProvider) {
        this.webServiceEndpointUrl = webServiceEndpointUrl;
        this.httpProxy = httpProxy;
        webServiceConnectionTimeout = this.getWebServiceConnectionTimeout();
        this.addCommonFields(coreMetadataProvider);
    }

    private void addCommonFields(AuditCoreMetadataProvider coreMetadataProvider) {
        this.auditEventCommonFields.put("processId", coreMetadataProvider.getProcessId().toString());
        this.auditEventCommonFields.put("threadId", coreMetadataProvider.getThreadId());
        this.auditEventCommonFields.put("eventOrder", coreMetadataProvider.getEventOrder());
        this.auditEventCommonFields.put("eventTime", coreMetadataProvider.getEventTime().toString());
        this.auditEventCommonFields.put("eventTimeSource", coreMetadataProvider.getEventTimeSource());
    }

    public void setApplication(String applicationId) {
        this.auditEventCommonFields.put("applicationId", applicationId);
    }

    public void setUser(String userId) {
        this.auditEventCommonFields.put("userId", userId);
    }

    public void setTenant(String tenantId) {
        if (tenantId.contains(",")) {
            String errorMessage = "Invalid characters (i.e commas) in the tenant identifier: " + tenantId;
            LOG.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        this.auditEventCommonFields.put("tenantId", tenantId.toLowerCase());
    }

    public void setCorrelationId(String correlationId) {
        this.auditEventCommonFields.put("correlationId", correlationId);
    }

    public void setEventType(String eventCategoryId, String eventTypeId) {
        this.auditEventCommonFields.put("eventCategoryId", eventCategoryId);
        this.auditEventCommonFields.put("eventTypeId", eventTypeId);
    }

    public void addEventParameter(String name, String columnName, String value) {
        this.auditEventParams.add(new EventParam(name, "string", columnName, value));
    }

    public void addEventParameter(String name, String columnName, String value, AuditIndexingHint indexingHint) {
        this.auditEventParams.add(new EventParam(name, "string", columnName, value, indexingHint));
    }

    public void addEventParameter(String name, String columnName, short value) {
        this.auditEventParams.add(new EventParam(name, "short", columnName, value));
    }

    public void addEventParameter(String name, String columnName, int value) {
        this.auditEventParams.add(new EventParam(name, "int", columnName, value));
    }

    public void addEventParameter(String name, String columnName, long value) {
        this.auditEventParams.add(new EventParam(name, "long", columnName, value));
    }

    public void addEventParameter(String name, String columnName, float value) {
        this.auditEventParams.add(new EventParam(name, "float", columnName, Float.valueOf(value)));
    }

    public void addEventParameter(String name, String columnName, double value) {
        this.auditEventParams.add(new EventParam(name, "double", columnName, value));
    }

    public void addEventParameter(String name, String columnName, boolean value) {
        this.auditEventParams.add(new EventParam(name, "boolean", columnName, value));
    }

    public void addEventParameter(String name, String columnName, Date value) {
        this.auditEventParams.add(new EventParam(name, "date", columnName, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws IOException, WebServiceClientException {
        String auditEventJson = this.getAuditEventAsJsonString();
        if (auditEventJson == null || auditEventJson.isEmpty()) {
            String errorMessage = "No Audit Event JSON to send to the Audit WebService";
            LOG.error(errorMessage);
            throw new WebServiceClientException(errorMessage);
        }
        byte[] auditEventJsonBytes = auditEventJson.getBytes("UTF-8");
        HttpURLConnection webServiceHttpUrlConnection = this.getWebServiceHttpEndpointUrlConnection(auditEventJsonBytes.length);
        try (OutputStream outputStream = webServiceHttpUrlConnection.getOutputStream();){
            outputStream.write(auditEventJsonBytes);
            outputStream.close();
        }
        try {
            int responseCode = webServiceHttpUrlConnection.getResponseCode();
            int expectedResponseCode = 204;
            if (responseCode >= 200 && responseCode < 300) {
                if (responseCode != expectedResponseCode) {
                    LOG.warn("Webservice accepted request but returned response code " + responseCode + " when the expected response code is " + expectedResponseCode);
                }
            } else {
                String errorMessage = "Webservice returned response code " + responseCode + " when the expected response code is " + expectedResponseCode;
                LOG.error(errorMessage);
                throw new WebServiceClientException(errorMessage);
            }
            LOG.info("Audit event request sent and received response code " + responseCode + " from the WebService");
        }
        finally {
            webServiceHttpUrlConnection.disconnect();
        }
    }

    private static void configureHttpUrlConnection(HttpURLConnection httpUrlConnection, int streamingModeLength) {
        httpUrlConnection.setConnectTimeout(webServiceConnectionTimeout);
        httpUrlConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setFixedLengthStreamingMode(streamingModeLength);
    }

    private HttpURLConnection getWebServiceHttpEndpointUrlConnection(int streamingModeLength) throws IOException {
        HttpURLConnection webServiceHttpUrlConn = this.httpProxy == null ? (this.webServiceEndpointUrl.getProtocol().equalsIgnoreCase("https") ? (HttpsURLConnection)this.webServiceEndpointUrl.openConnection() : (HttpURLConnection)this.webServiceEndpointUrl.openConnection()) : (this.webServiceEndpointUrl.getProtocol().equalsIgnoreCase("https") ? (HttpsURLConnection)this.webServiceEndpointUrl.openConnection(this.httpProxy) : (HttpURLConnection)this.webServiceEndpointUrl.openConnection(this.httpProxy));
        WebServiceClientAuditEventBuilder.configureHttpUrlConnection(webServiceHttpUrlConn, streamingModeLength);
        return webServiceHttpUrlConn;
    }

    private static int getWebServiceConnectionTimeout() {
        int webServiceTimeout;
        try {
            webServiceTimeout = Integer.parseInt(System.getProperty(AUDIT_WS_CONN_TIMEOUT, System.getenv(AUDIT_WS_CONN_TIMEOUT)));
        }
        catch (NumberFormatException efe) {
            LOG.debug("Unable to parse timeout value from AUDIT_WS_CONN_TIMEOUT system or environment variable, defaulting timeout to 30 seconds");
            webServiceTimeout = 30000;
        }
        return webServiceTimeout;
    }

    private String getAuditEventAsJsonString() throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
        jsonBuilder.startObject();
        for (Map.Entry<String, Object> auditEventCommonField : this.auditEventCommonFields.entrySet()) {
            jsonBuilder.field(auditEventCommonField.getKey(), auditEventCommonField.getValue());
        }
        if (this.auditEventParams != null && !this.auditEventParams.isEmpty()) {
            jsonBuilder.startArray("eventParams");
            for (EventParam auditEventParam : this.auditEventParams) {
                XContentBuilder customEventParamBuilder = jsonBuilder.startObject().field("paramName", auditEventParam.getParamName()).field("paramType", auditEventParam.getParamType());
                if (auditEventParam.getParamIndexingHint() != null) {
                    customEventParamBuilder.field("paramIndexingHint", auditEventParam.getParamIndexingHint().toString().toLowerCase());
                }
                customEventParamBuilder.field("paramValue", auditEventParam.getParamValue()).field("paramColumnName", auditEventParam.getParamColumnName()).endObject();
            }
            jsonBuilder.endArray();
        }
        jsonBuilder.endObject();
        jsonBuilder.close();
        return jsonBuilder.string();
    }

    private class EventParam {
        private String paramName;
        private String paramType;
        private String paramColumnName;
        private Object paramValue;
        private AuditIndexingHint paramIndexingHint;

        public EventParam(String paramName, String paramType, String paramColumnName, Object paramValue, AuditIndexingHint paramIndexingHint) {
            this.paramName = paramName;
            this.paramType = paramType;
            this.paramColumnName = paramColumnName;
            this.paramValue = paramValue;
            this.paramIndexingHint = paramIndexingHint;
        }

        public EventParam(String paramName, String paramType, String paramColumnName, Object paramValue) {
            this.paramName = paramName;
            this.paramType = paramType;
            this.paramColumnName = paramColumnName;
            this.paramValue = paramValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getParamType() {
            return this.paramType;
        }

        public void setParamType(String paramType) {
            this.paramType = paramType;
        }

        public String getParamColumnName() {
            return this.paramColumnName;
        }

        public void setParamColumnName(String paramColumnName) {
            this.paramColumnName = paramColumnName;
        }

        public AuditIndexingHint getParamIndexingHint() {
            return this.paramIndexingHint;
        }

        public void setParamIndexingHint(AuditIndexingHint paramIndexingHint) {
            this.paramIndexingHint = paramIndexingHint;
        }

        public Object getParamValue() {
            return this.paramValue;
        }

        public void setParamValue(Object paramValue) {
            this.paramValue = paramValue;
        }
    }
}

