/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api;

import com.hpe.caf.boilerplate.api.BoilerplateApi;
import com.hpe.caf.boilerplate.api.BoilerplateExpression;
import com.hpe.caf.boilerplate.api.Tag;
import com.hpe.caf.boilerplate.api.exceptions.InvalidRequestException;
import com.hpe.caf.boilerplate.api.exceptions.ItemNotFoundException;
import com.hpe.caf.boilerplate.api.exceptions.ParameterOutOfRangeException;
import com.hpe.caf.boilerplate.api.exceptions.TransitoryBackEndFailureException;
import com.hpe.caf.boilerplate.api.hibernate.ExecutionContext;
import com.hpe.caf.boilerplate.api.hibernate.ExecutionContextProvider;
import com.hpe.caf.boilerplate.api.hibernate.repositories.BoilerplateExpressionRepositoryImpl;
import com.hpe.caf.boilerplate.api.hibernate.repositories.TagRepositoryImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoilerplateApiRepositoryImpl
implements BoilerplateApi {
    private BoilerplateExpressionRepositoryImpl boilerplateExpressionRepository;
    private TagRepositoryImpl tagRepository;
    private ExecutionContextProvider contextProvider;
    private static final Logger logger = LoggerFactory.getLogger(BoilerplateApiRepositoryImpl.class);

    @Autowired
    public BoilerplateApiRepositoryImpl(ExecutionContextProvider contextProvider, BoilerplateExpressionRepositoryImpl boilerplateExpressionRepository, TagRepositoryImpl tagRepository) {
        this.boilerplateExpressionRepository = boilerplateExpressionRepository;
        this.tagRepository = tagRepository;
        this.contextProvider = contextProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tag getTag(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            Tag tag = context.retryNonTransactional(r -> {
                Tag result = this.tagRepository.retrieve(context, Collections.singletonList(id)).stream().findFirst().get();
                return result;
            });
            return tag;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Tag> getTags() {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<Tag> result = new ArrayList<Tag>(this.tagRepository.retrieveAll(context));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Tag> getTags(int pageNumber, int size) {
        if (pageNumber < 1) {
            throw new ParameterOutOfRangeException("Invalid Parameter", new Exception("The field start must be >0"));
        }
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<Tag> result = new ArrayList<Tag>(this.tagRepository.retrievePaged(context, size, pageNumber));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BoilerplateExpression getExpression(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            BoilerplateExpression boilerplateExpression = context.retryNonTransactional(r -> {
                BoilerplateExpression expression = this.boilerplateExpressionRepository.retrieve(context, Collections.singletonList(id)).stream().findFirst().get();
                return expression;
            });
            return boilerplateExpression;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BoilerplateExpression> getExpressions(int pageNumber, int size) {
        if (pageNumber < 1) {
            throw new ParameterOutOfRangeException("Invalid Parameter", new Exception("The field start must be >0"));
        }
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<BoilerplateExpression> result = new ArrayList<BoilerplateExpression>(this.boilerplateExpressionRepository.retrievePaged(context, size, pageNumber));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Tag> getTagsByExpressionId(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<Tag> result = new ArrayList<Tag>(this.tagRepository.retrieveByExpression(context, id));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BoilerplateExpression> getExpressionsByTagId(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<BoilerplateExpression> result = new ArrayList<BoilerplateExpression>(this.boilerplateExpressionRepository.retrieveByTag(context, this.getTag(id)));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BoilerplateExpression> getExpressionsByTagId(long id, int pageNumber, int size) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            List list = context.retryNonTransactional(r -> {
                ArrayList<BoilerplateExpression> result = new ArrayList<BoilerplateExpression>(this.boilerplateExpressionRepository.retrieveByTagPaged(context, this.getTag(id), size, pageNumber));
                return result;
            });
            return list;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tag createTag(Tag tag) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            Tag tag2 = context.retry(r -> {
                Tag result = this.tagRepository.create(context, tag);
                return result;
            });
            return tag2;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BoilerplateExpression createExpression(BoilerplateExpression expression) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            BoilerplateExpression boilerplateExpression = context.retry(r -> {
                BoilerplateExpression result = this.boilerplateExpressionRepository.create(context, expression);
                return result;
            });
            return boilerplateExpression;
        }
        catch (InvalidRequestException | ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tag updateTag(Tag tag) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            Tag tag2 = context.retry(r -> {
                Tag result = this.tagRepository.update(context, tag);
                return result;
            });
            return tag2;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BoilerplateExpression updateExpression(BoilerplateExpression expression) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            BoilerplateExpression boilerplateExpression = context.retry(r -> {
                BoilerplateExpression result = this.boilerplateExpressionRepository.update(context, expression);
                return result;
            });
            return boilerplateExpression;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Tag deleteTag(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            Tag tag = context.retry(r -> this.tagRepository.delete(context, id));
            return tag;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BoilerplateExpression deleteExpression(long id) {
        try (ExecutionContext context = this.contextProvider.getExecutionContext();){
            BoilerplateExpression boilerplateExpression = context.retry(r -> this.boilerplateExpressionRepository.delete(context, id));
            return boilerplateExpression;
        }
        catch (ItemNotFoundException | ParameterOutOfRangeException | TransitoryBackEndFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

