/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class EnvironmentConfigurer {
    private static Logger logger = LoggerFactory.getLogger(EnvironmentConfigurer.class);

    public static void configure(ConfigurableEnvironment configurableEnvironment) {
        for (String active : configurableEnvironment.getActiveProfiles()) {
            logger.info("PRE PROFILE: " + active);
        }
        if (Arrays.asList(configurableEnvironment.getActiveProfiles()).stream().noneMatch(p -> p.equalsIgnoreCase("webserver"))) {
            configurableEnvironment.addActiveProfile("threadusercontext");
            configurableEnvironment.addActiveProfile("application-scope");
        } else {
            configurableEnvironment.addActiveProfile("web-application-scope");
        }
        for (String active : configurableEnvironment.getActiveProfiles()) {
            logger.info("POST PROFILE: " + active);
        }
    }
}

