/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ExecutionContext
implements AutoCloseable {
    private Session session;

    public ExecutionContext(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public <R> R retry(Function<?, R> retry) {
        Transaction transaction = null;
        try {
            transaction = this.session.beginTransaction();
            R result = retry.apply(null);
            transaction.commit();
            return result;
        }
        catch (Exception e) {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }

    public void retryNoReturn(Consumer<?> retry) {
        Transaction transaction = null;
        try {
            transaction = this.session.beginTransaction();
            retry.accept(null);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }

    public <R> R retryNonTransactional(Function<?, R> retry) {
        try {
            R result = retry.apply(null);
            return result;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.session.close();
    }
}

