/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate;

import com.hpe.caf.boilerplate.api.exceptions.TransitoryBackEndFailureException;
import com.hpe.caf.boilerplate.api.hibernate.HibernateProperties;
import com.hpe.caf.boilerplate.api.hibernate.PreInsertInterceptor;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HibernateSessionFactory {
    private static Lock lock = new ReentrantLock();
    private static SessionFactory factory;
    private static Logger logger;
    private final PreInsertInterceptor preInsertInterceptor;
    private final HibernateProperties hibernateProperties;
    private final String JDBC_PREFIX = "jdbc:";

    @Autowired
    public HibernateSessionFactory(HibernateProperties hibernateProperties, PreInsertInterceptor preInsertInterceptor) {
        this.preInsertInterceptor = preInsertInterceptor;
        this.hibernateProperties = hibernateProperties;
    }

    private SessionFactory getSessionFactory() {
        if (factory == null) {
            lock.lock();
            try {
                if (factory == null) {
                    Configuration configuration = new Configuration();
                    configuration.configure();
                    configuration.setInterceptor((Interceptor)this.preInsertInterceptor);
                    configuration.setProperty("hibernate.connection.url", this.hibernateProperties.getConnectionString());
                    configuration.setProperty("hibernate.connection.username", this.hibernateProperties.getUser());
                    configuration.setProperty("hibernate.connection.password", this.hibernateProperties.getPassword());
                    configuration.setProperty("hibernate.connection.driver_class", this.getDriverClass());
                    StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
                    factory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return factory;
    }

    private String getDriverClass() throws TransitoryBackEndFailureException {
        String connection = this.hibernateProperties.getConnectionString().toLowerCase();
        if (!connection.startsWith("jdbc:")) {
            throw new TransitoryBackEndFailureException("Database Connection Failure", new Exception("Invalid hibernate connection string format. Must start with jdbc:"));
        }
        int index = connection.indexOf(":", "jdbc:".length());
        if (index == -1) {
            throw new TransitoryBackEndFailureException("Database Connection Failure", new Exception("Invalid hibernate connection string format. Must be of the format jdbc:xxx:"));
        }
        String connectionType = connection.substring("jdbc:".length(), index);
        switch (connectionType.toLowerCase()) {
            case "postgresql": {
                logger.info("Detected driver required as postgresql");
                return "org.postgresql.Driver";
            }
            case "h2": {
                logger.info("Detected driver required as h2");
                return "org.h2.Driver";
            }
        }
        logger.warn("Unknown jdbc driver type.");
        String driverClass = System.getProperty("hibernate.connection.driver_class");
        if (driverClass == null || driverClass.isEmpty()) {
            throw new TransitoryBackEndFailureException("Database Connection Failure", new Exception("Unknown hibernate driver type - to add support please specify environment option hibernate.connection.driver_class."));
        }
        logger.info("Using externally supplied driver class: " + driverClass);
        return driverClass;
    }

    public void closeSession() {
        if (factory == null) {
            return;
        }
        try {
            lock.lock();
            factory.close();
            factory = null;
        }
        finally {
            lock.unlock();
        }
    }

    public Session getSession() throws TransitoryBackEndFailureException {
        try {
            return this.getSessionFactory().openSession();
        }
        catch (HibernateException e) {
            throw new TransitoryBackEndFailureException("Database Connection failure", e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(HibernateSessionFactory.class);
    }
}

