/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate;

import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Primary
@Component
@Scope(value="prototype")
public class ObjectValidator<Object> {
    private ValidatorFactory validatorFactory;

    @Autowired
    public ObjectValidator(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ValidationResult validate(Object objectToValidate) {
        Set validate = this.validatorFactory.getValidator().validate(objectToValidate, new Class[0]);
        if (validate != null && validate.size() > 0) {
            return new ValidationResult(validate.stream().map(ConstraintViolation::getMessage).distinct().collect(Collectors.joining("\n")));
        }
        return new ValidationResult();
    }

    class ValidationResult {
        private String reason;
        private boolean valid;

        public ValidationResult(String reason) {
            this.reason = reason;
            this.valid = false;
        }

        public ValidationResult() {
            this.reason = null;
            this.valid = true;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

