/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate;

import com.hpe.caf.boilerplate.api.DtoBase;
import com.hpe.caf.boilerplate.api.UserContext;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreInsertInterceptor
extends EmptyInterceptor {
    private UserContext userContext;

    @Autowired
    public PreInsertInterceptor(UserContext userContext) {
        this.userContext = userContext;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        return this.addProjectId(propertyNames, state);
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return this.addProjectId(propertyNames, currentState);
    }

    private boolean addProjectId(String[] propertyNames, Object[] state) {
        boolean stateModified = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            Object o = state[i];
            if ("projectId".equalsIgnoreCase(propertyNames[i]) || "project_id".equalsIgnoreCase(propertyNames[i])) {
                state[i] = this.userContext.getProjectId();
                stateModified = true;
                break;
            }
            if (!(o instanceof DtoBase)) continue;
            try {
                Field projectIdField = DtoBase.class.getDeclaredField("projectId");
                if (projectIdField == null) continue;
                projectIdField.setAccessible(true);
                try {
                    projectIdField.set(o, this.userContext.getProjectId());
                }
                catch (IllegalAccessException ignored) {}
                continue;
            }
            catch (NoSuchFieldException ignored) {
                // empty catch block
            }
        }
        return stateModified;
    }
}

