/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate.repositories;

import com.hpe.caf.boilerplate.api.BoilerplateExpression;
import com.hpe.caf.boilerplate.api.Tag;
import com.hpe.caf.boilerplate.api.UserContext;
import com.hpe.caf.boilerplate.api.exceptions.InvalidRequestException;
import com.hpe.caf.boilerplate.api.exceptions.ItemNotFoundException;
import com.hpe.caf.boilerplate.api.exceptions.ItemType;
import com.hpe.caf.boilerplate.api.exceptions.ParameterOutOfRangeException;
import com.hpe.caf.boilerplate.api.hibernate.ExecutionContext;
import com.hpe.caf.boilerplate.api.hibernate.repositories.HibernateBaseRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoilerplateExpressionRepositoryImpl
extends HibernateBaseRepository<BoilerplateExpression> {
    @Autowired
    public BoilerplateExpressionRepositoryImpl(UserContext userContext) {
        super(userContext);
    }

    @Override
    public BoilerplateExpression create(ExecutionContext context, BoilerplateExpression boilerplateExpression) {
        boilerplateExpression.setId(null);
        if (boilerplateExpression.getId() != null) {
            throw new RuntimeException("Id should be null");
        }
        if (boilerplateExpression.getExpression() == null) {
            throw new InvalidRequestException("expression should not be null.", new Exception("Unable to save Boilerplate Expression."), ItemType.BOILERPLATE_EXPRESSION);
        }
        context.getSession().save((Object)boilerplateExpression);
        context.getSession().flush();
        this.evict(context.getSession(), boilerplateExpression);
        return (BoilerplateExpression)this.retrieveSingleItem(context, boilerplateExpression.getId());
    }

    @Override
    public BoilerplateExpression update(ExecutionContext context, BoilerplateExpression boilerplateExpression) {
        this.retrieve(context, Collections.singletonList(boilerplateExpression.getId()));
        if (boilerplateExpression.getExpression() == null) {
            throw new InvalidRequestException("expression should not be null.", new Exception("Unable to update Boilerplate Expression."), ItemType.BOILERPLATE_EXPRESSION);
        }
        context.getSession().update((Object)boilerplateExpression);
        context.getSession().flush();
        this.evict(context.getSession(), boilerplateExpression);
        return (BoilerplateExpression)this.retrieveSingleItem(context, boilerplateExpression.getId());
    }

    @Override
    public BoilerplateExpression delete(ExecutionContext context, Long id) {
        BoilerplateExpression expression = (BoilerplateExpression)this.retrieveSingleItem(context, id);
        String hql = "delete from BoilerplateExpression where id= :id";
        int i = context.getSession().createQuery(hql).setLong("id", id.longValue()).executeUpdate();
        if (i == 0) {
            throw new RuntimeException("Boilerplate Expression could not be deleted");
        }
        return expression;
    }

    @Override
    public Collection<BoilerplateExpression> retrieve(ExecutionContext context, Collection<Long> ids) {
        Criteria criteria = context.getSession().createCriteria(BoilerplateExpression.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.add(Restrictions.in((String)"id", ids)).add((Criterion)Restrictions.eq((String)"projectId", (Object)this.userContext.getProjectId())).addOrder(Order.asc((String)"id"));
        List items = criteria.list();
        this.evict(context.getSession(), items);
        if (!ids.stream().distinct().allMatch(u -> items.stream().anyMatch(i -> Objects.equals(i.getId(), u)))) {
            if (ids.size() == 1) {
                throw new ItemNotFoundException("Request Failure", new Exception("Could not find a match for the BoilerplateExpression requested."), ItemType.BOILERPLATE_EXPRESSION);
            }
            throw new ItemNotFoundException("Request Failure", new Exception("Could not find a match for the BoilerplateExpressions requested."), ItemType.BOILERPLATE_EXPRESSION);
        }
        return items;
    }

    @Override
    public BoilerplateExpression preSave(BoilerplateExpression boilerplateExpression, Session session) {
        String projectId = this.userContext.getProjectId();
        if (projectId != null && !projectId.isEmpty()) {
            return boilerplateExpression;
        }
        throw new ParameterOutOfRangeException("Missing Parameter", new Exception("Cannot save item, projectId is null."));
    }

    @Override
    public Collection<BoilerplateExpression> retrieveAll(ExecutionContext context) {
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(BoilerplateExpression.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).addOrder(Order.asc((String)"id"));
        List results = criteria.list();
        for (BoilerplateExpression expression : results) {
            context.getSession().evict((Object)expression);
        }
        return results;
    }

    @Override
    public Collection<BoilerplateExpression> retrievePaged(ExecutionContext context, int maxSize, int startPage) {
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(BoilerplateExpression.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).addOrder(Order.asc((String)"id")).setMaxResults(maxSize).setFirstResult(startPage - 1);
        List results = criteria.list();
        for (BoilerplateExpression expression : results) {
            context.getSession().evict((Object)expression);
        }
        return results;
    }

    public Collection<BoilerplateExpression> retrieveByTag(ExecutionContext context, Tag tag) {
        Collection<Long> boilerplateExpressionsOnTag = tag.getBoilerplateExpressions();
        if (boilerplateExpressionsOnTag == null || boilerplateExpressionsOnTag.size() == 0) {
            return new ArrayList<BoilerplateExpression>();
        }
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(BoilerplateExpression.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).add(Restrictions.in((String)"id", tag.getBoilerplateExpressions())).addOrder(Order.asc((String)"id"));
        List results = criteria.list();
        for (BoilerplateExpression expression : results) {
            context.getSession().evict((Object)expression);
        }
        return results;
    }

    public Collection<BoilerplateExpression> retrieveByTagPaged(ExecutionContext context, Tag tag, int maxSize, int startPage) {
        Collection<Long> boilerplateExpressionsOnTag = tag.getBoilerplateExpressions();
        if (boilerplateExpressionsOnTag == null || boilerplateExpressionsOnTag.size() == 0) {
            return new ArrayList<BoilerplateExpression>();
        }
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(BoilerplateExpression.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).add(Restrictions.in((String)"id", tag.getBoilerplateExpressions())).addOrder(Order.asc((String)"id")).setMaxResults(maxSize).setFirstResult(startPage - 1);
        List results = criteria.list();
        for (BoilerplateExpression expression : results) {
            context.getSession().evict((Object)expression);
        }
        return results;
    }
}

