/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate.repositories;

import com.hpe.caf.boilerplate.api.UserContext;
import com.hpe.caf.boilerplate.api.hibernate.ExecutionContext;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.Session;

public abstract class HibernateBaseRepository<T> {
    protected UserContext userContext;

    public abstract T create(ExecutionContext var1, T var2);

    public abstract T update(ExecutionContext var1, T var2);

    public abstract T delete(ExecutionContext var1, Long var2);

    public abstract Collection<T> retrieve(ExecutionContext var1, Collection<Long> var2);

    public abstract T preSave(T var1, Session var2);

    public abstract Collection<T> retrieveAll(ExecutionContext var1);

    public abstract Collection<T> retrievePaged(ExecutionContext var1, int var2, int var3);

    public HibernateBaseRepository(UserContext userContext) {
        this.userContext = userContext;
    }

    protected void evict(Session session, T item) {
        if (item != null) {
            session.evict(item);
        }
    }

    protected void evict(Session session, Collection<T> items) {
        for (T item : items) {
            session.evict(item);
        }
    }

    protected T retrieveSingleItem(ExecutionContext context, Long id) {
        Collection<T> items = this.retrieve(context, Collections.singletonList(id));
        if (items.size() > 1) {
            throw new RuntimeException("To many items returned");
        }
        if (items.size() == 0) {
            return null;
        }
        return items.stream().findFirst().get();
    }
}

