/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.boilerplate.api.hibernate.repositories;

import com.hpe.caf.boilerplate.api.BoilerplateExpression;
import com.hpe.caf.boilerplate.api.Tag;
import com.hpe.caf.boilerplate.api.UserContext;
import com.hpe.caf.boilerplate.api.exceptions.InvalidRequestException;
import com.hpe.caf.boilerplate.api.exceptions.ItemNotFoundException;
import com.hpe.caf.boilerplate.api.exceptions.ItemType;
import com.hpe.caf.boilerplate.api.exceptions.ParameterOutOfRangeException;
import com.hpe.caf.boilerplate.api.hibernate.ExecutionContext;
import com.hpe.caf.boilerplate.api.hibernate.repositories.HibernateBaseRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TagRepositoryImpl
extends HibernateBaseRepository<Tag> {
    @Autowired
    public TagRepositoryImpl(UserContext userContext) {
        super(userContext);
    }

    @Override
    public Tag create(ExecutionContext context, Tag tag) {
        tag.setId(null);
        if (tag.getId() != null) {
            throw new RuntimeException("Id should be null");
        }
        if (tag.getBoilerplateExpressions() == null) {
            throw new InvalidRequestException("Boilerplate expressions should not be null.", new Exception("Unable to save Tag."), ItemType.TAG);
        }
        tag.setBoilerplateExpressions(new HashSet<Long>(tag.getBoilerplateExpressions()));
        tag = this.preSave(tag, context.getSession());
        context.getSession().save((Object)tag);
        context.getSession().flush();
        this.evict(context.getSession(), tag);
        return (Tag)this.retrieveSingleItem(context, tag.getId());
    }

    @Override
    public Tag update(ExecutionContext context, Tag tag) {
        this.retrieve(context, Collections.singletonList(tag.getId()));
        tag.setBoilerplateExpressions(new HashSet<Long>(tag.getBoilerplateExpressions()));
        this.preSave(tag, context.getSession());
        context.getSession().update((Object)tag);
        context.getSession().flush();
        this.evict(context.getSession(), tag);
        return (Tag)this.retrieveSingleItem(context, tag.getId());
    }

    @Override
    public Tag delete(ExecutionContext context, Long id) {
        Tag tag = (Tag)this.retrieveSingleItem(context, id);
        context.getSession().delete((Object)tag);
        return tag;
    }

    @Override
    public Collection<Tag> retrieve(ExecutionContext context, Collection<Long> ids) {
        Criteria criteria = context.getSession().createCriteria(Tag.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.add(Restrictions.in((String)"id", ids)).add((Criterion)Restrictions.eq((String)"projectId", (Object)this.userContext.getProjectId())).addOrder(Order.asc((String)"id"));
        List items = criteria.list();
        this.evict(context.getSession(), items);
        if (!ids.stream().distinct().allMatch(u -> items.stream().anyMatch(i -> Objects.equals(i.getId(), u)))) {
            if (ids.size() == 1) {
                throw new ItemNotFoundException("Request Failure", new Exception("Could not find a match for the Tag requested."), ItemType.TAG);
            }
            throw new ItemNotFoundException("Request Failure", new Exception("Could not find a match for all Tags requested."), ItemType.TAG);
        }
        return items;
    }

    @Override
    public Tag preSave(Tag tag, Session session) {
        String projectId = this.userContext.getProjectId();
        if (projectId != null && !projectId.isEmpty()) {
            if (tag.getBoilerplateExpressions().size() > 0) {
                Criteria criteria = session.createCriteria(BoilerplateExpression.class).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                criteria.add(Restrictions.in((String)"id", tag.getBoilerplateExpressions())).add((Criterion)Restrictions.eq((String)"projectId", (Object)this.userContext.getProjectId()));
                List items = criteria.list();
                if (items.size() != tag.getBoilerplateExpressions().size()) {
                    throw new ItemNotFoundException("Request Failure", new RuntimeException("Cannot save Tag using Boilerplate Expression ids from different tenant."), ItemType.BOILERPLATE_EXPRESSION);
                }
                for (BoilerplateExpression i : items) {
                    session.evict((Object)i);
                }
            }
            return tag;
        }
        throw new ParameterOutOfRangeException("Missing Parameter", new Exception("Cannot save item, projectId is null."));
    }

    @Override
    public Collection<Tag> retrieveAll(ExecutionContext context) {
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(Tag.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).addOrder(Order.asc((String)"id"));
        List results = criteria.list();
        for (Tag tag : results) {
            context.getSession().evict((Object)tag);
        }
        return results;
    }

    @Override
    public Collection<Tag> retrievePaged(ExecutionContext context, int maxSize, int startPage) {
        String projectId = this.userContext.getProjectId();
        Criteria criteria = context.getSession().createCriteria(Tag.class).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).addOrder(Order.asc((String)"id")).setMaxResults(maxSize).setFirstResult(startPage - 1);
        List results = criteria.list();
        for (Tag tag : results) {
            context.getSession().evict((Object)tag);
        }
        return results;
    }

    public Collection<Tag> retrieveByExpression(ExecutionContext context, Long expressionId) {
        String projectId = this.userContext.getProjectId();
        List results = context.getSession().createCriteria(Tag.class).createAlias("boilerplateExpressions", "boilerplateExpressions", JoinType.INNER_JOIN).addOrder(Order.asc((String)"id")).add(Restrictions.isNotEmpty((String)"boilerplateExpressions")).add(Restrictions.in((String)"boilerplateExpressions.elements", Collections.singletonList(expressionId))).add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId)).list();
        for (Tag tag : results) {
            context.getSession().evict((Object)tag);
        }
        return results;
    }
}

