/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.cafdataprocessing.corepolicy.ConditionEngine;
import com.github.cafdataprocessing.corepolicy.EnvironmentSnapshotCache;
import com.github.cafdataprocessing.corepolicy.common.ConditionEngineMetadata;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequenceEntry;
import com.github.cafdataprocessing.corepolicy.common.dto.ConditionEngineResult;
import com.github.cafdataprocessing.corepolicy.common.dto.DocumentCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.EvaluateCondition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConditionEngineImpl
implements ConditionEngine {
    private static final Logger logger = LoggerFactory.getLogger(ConditionEngineImpl.class);
    private EvaluateCondition evaluateCondition;
    private EnvironmentSnapshotCache environmentSnapshotCache;
    private ConditionEngineMetadata conditionEngineMetadata;

    @Autowired
    public ConditionEngineImpl(EvaluateCondition evaluateCondition, EnvironmentSnapshotCache environmentSnapshotCache, ConditionEngineMetadata conditionEngineMetadata) {
        this.evaluateCondition = evaluateCondition;
        this.environmentSnapshotCache = environmentSnapshotCache;
        this.conditionEngineMetadata = conditionEngineMetadata;
    }

    @Override
    public ConditionEngineResult evaluate(DocumentUnderEvaluation document, long collectionSequenceId) throws CpeException {
        EnvironmentSnapshot environmentSnapshot = this.getConditionEngineRepository(collectionSequenceId);
        return this.evaluate(document, collectionSequenceId, environmentSnapshot);
    }

    @Override
    public ConditionEngineResult evaluate(DocumentUnderEvaluation document, long collectionSequenceId, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        ConditionEngineResult previousResult = this.conditionEngineMetadata.createResultFromMetadata(document.getMetadata());
        Stopwatch stopwatch = Stopwatch.createStarted();
        ConditionEngineResult conditionEngineResult = new ConditionEngineResult();
        conditionEngineResult.reference = document.getReference();
        Stopwatch getEnvironmentStopwatch = Stopwatch.createStarted();
        CollectionSequence collectionSequence = environmentSnapshot.getSequence(Long.valueOf(collectionSequenceId));
        document.logTime("Evaluate-GetEnvironment", getEnvironmentStopwatch);
        logger.trace("Using environment: " + environmentSnapshot.getInstanceId() + " Created: " + environmentSnapshot.getCreateDate() + " CollSequence LastModified: " + environmentSnapshot.getCollectionSequenceLastModifiedDate());
        if (!collectionSequence.evaluationEnabled) {
            document.logTime("Evaluate", stopwatch);
            logger.trace("Collection Sequence " + collectionSequence.id + " evaluation disabled");
            return conditionEngineResult;
        }
        List collectionSequenceEntries = collectionSequence.collectionSequenceEntries;
        for (CollectionSequenceEntry entry : collectionSequenceEntries) {
            boolean matchedTheCollection = false;
            Stopwatch allCollectionsStopwatch = Stopwatch.createStarted();
            Set collectionIds = entry.collectionIds;
            for (Long collectionId : collectionIds) {
                Stopwatch collectionStopwatch = Stopwatch.createStarted();
                if (this.evaluateCollection(collectionSequence, document, conditionEngineResult, environmentSnapshot, collectionId)) {
                    matchedTheCollection = true;
                }
                document.logTime("Evaluate-Collection" + collectionId, collectionStopwatch);
            }
            document.logTime("Evaluate-AllCollections", allCollectionsStopwatch);
            if (!matchedTheCollection || !entry.stopOnMatch.booleanValue()) continue;
            document.logTime("Evaluate", stopwatch);
            return conditionEngineResult;
        }
        if (conditionEngineResult.matchedCollections.isEmpty() && collectionSequence.defaultCollectionId != null && collectionSequence.defaultCollectionId != 0L) {
            this.assignDefaultCollection(conditionEngineResult, environmentSnapshot, collectionSequence);
        }
        document.logTime("Evaluate", stopwatch);
        if (conditionEngineResult.matchedCollections != null) {
            conditionEngineResult.matchedCollections.forEach(mc -> {
                if (mc.getPolicies() != null) {
                    mc.getPolicies().forEach(p -> {
                        block6: {
                            p.setName("Policy does not exist");
                            try {
                                Policy policy = environmentSnapshot.getPolicy(p.getId());
                                if (policy == null) break block6;
                                if (policy.name.startsWith("CLASSIFICATION_CONDITION_ID:")) {
                                    try {
                                        ObjectMapper objectMapper = new ObjectMapper();
                                        String unescaped = StringEscapeUtils.unescapeEcmaScript((String)policy.description);
                                        ObjectNode objectNode = (ObjectNode)objectMapper.readValue(unescaped.substring(1, unescaped.length() - 1), ObjectNode.class);
                                        if (objectNode.has("name")) {
                                            p.setName(objectNode.get("name").asText());
                                        }
                                        break block6;
                                    }
                                    catch (Exception e) {
                                        logger.error("Detected a policy created by the classification API and failed to extract real name from the description.", (Throwable)e);
                                        p.setName(policy.name);
                                    }
                                    break block6;
                                }
                                p.setName(policy.name);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
        }
        return conditionEngineResult;
    }

    protected EnvironmentSnapshot getConditionEngineRepository(long collectionSequenceId) throws CpeException {
        EnvironmentSnapshot environmentSnapshot;
        try {
            environmentSnapshot = this.environmentSnapshotCache.get(collectionSequenceId);
        }
        catch (Exception e) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.GeneralFailure, (Throwable)e);
        }
        return environmentSnapshot;
    }

    private void assignDefaultCollection(ConditionEngineResult conditionEngineResult, EnvironmentSnapshot environmentSnapshot, CollectionSequence collectionSequence) {
        DocumentCollection defaultCollection = environmentSnapshot.getCollection(collectionSequence.defaultCollectionId);
        conditionEngineResult.matchedCollections.add(new MatchedCollection(defaultCollection, Arrays.asList(new MatchedCondition[0])));
        conditionEngineResult.collectionIdAssignedByDefault = defaultCollection.id;
    }

    private boolean evaluateCollection(CollectionSequence collectionSequence, DocumentUnderEvaluation document, ConditionEngineResult conditionEngineResult, EnvironmentSnapshot environmentSnapshot, Long collectionId) throws CpeException {
        boolean matchedTheCollection = false;
        DocumentCollection collection = environmentSnapshot.getCollection(collectionId);
        if (collection.condition != null) {
            Condition condition = collection.condition;
            ConditionEvaluationResult conditionEvaluationResult = this.evaluateCondition.evaluate(collectionSequence, document, condition, environmentSnapshot);
            if (conditionEvaluationResult.isMatch()) {
                conditionEngineResult.matchedCollections.add(new MatchedCollection(collection, conditionEvaluationResult.getMatchedConditions()));
                matchedTheCollection = true;
            }
            if (conditionEvaluationResult.getUnevaluatedConditions().size() != 0) {
                conditionEngineResult.unevaluatedConditions.addAll(conditionEvaluationResult.getUnevaluatedConditions());
                if (!matchedTheCollection) {
                    conditionEngineResult.incompleteCollections.add(collectionId);
                }
            }
            conditionEngineResult.unmatchedConditions.addAll(conditionEvaluationResult.getUnmatchedConditions());
            conditionEngineResult.matchedConditions.addAll(conditionEvaluationResult.getAllConditionMatches());
        }
        return matchedTheCollection;
    }
}

