/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy;

import com.github.cafdataprocessing.corepolicy.ExcludedContentProcessor;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.ExcludedFragment;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.shared.ChangedValue;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.EvaluateCondition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ExcludedContentProcessorImpl
implements ExcludedContentProcessor {
    private EvaluateCondition evaluateCondition;
    private Comparator<ExcludedFragment> byOrder = (e1, e2) -> Integer.compare(e1.order.shortValue(), e2.order.shortValue());

    @Autowired
    public ExcludedContentProcessorImpl(EvaluateCondition evaluateCondition) {
        this.evaluateCondition = evaluateCondition;
    }

    @Override
    public void removeExcludedFragments(DocumentUnderEvaluation document, Collection<ExcludedFragment> excludedFragments) {
        for (ExcludedFragment excludedFragment : excludedFragments.stream().sorted(this.byOrder).collect(Collectors.toList())) {
            for (String fieldName : excludedFragment.fieldNames) {
                Collection fieldValues = document.getMetadata().get((Object)fieldName);
                List<ChangedValue> updatedFieldValues = fieldValues.stream().map(value -> new ChangedValue(value, (Object)new MetadataValue(value.getApiProperties(), value.getAsString().replaceAll(excludedFragment.pattern, "")))).collect(Collectors.toList());
                updatedFieldValues.forEach(u -> {
                    if (u.hasChanged()) {
                        document.getMetadata().remove((Object)fieldName, u.getOldValue());
                        document.getMetadata().put((Object)fieldName, u.getNewValue());
                    }
                });
            }
        }
        if (document.getDocuments() != null) {
            document.getDocuments().forEach(u -> this.removeExcludedFragments((DocumentUnderEvaluation)u, excludedFragments));
        }
    }

    @Override
    public Collection<DocumentUnderEvaluation> setExcludedDocuments(CollectionSequence collectionSequence, DocumentUnderEvaluation document, Long excludedConditionId, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        if (excludedConditionId == null) {
            return Arrays.asList(new DocumentUnderEvaluation[0]);
        }
        Condition condition = environmentSnapshot.getCondition(excludedConditionId);
        this.setExcludedDocuments(collectionSequence, document, condition, environmentSnapshot);
        LinkedList<DocumentUnderEvaluation> excludedDocuments = new LinkedList<DocumentUnderEvaluation>();
        this.populateExcludedDocuments(excludedDocuments, document);
        return excludedDocuments;
    }

    private void populateExcludedDocuments(Collection<DocumentUnderEvaluation> excludedDocuments, DocumentUnderEvaluation document) {
        if (document.getIsExcluded().booleanValue()) {
            excludedDocuments.add(document);
        }
        for (DocumentUnderEvaluation childDocument : document.getDocuments()) {
            this.populateExcludedDocuments(excludedDocuments, childDocument);
        }
    }

    private void setExcludedDocuments(CollectionSequence collectionSequence, DocumentUnderEvaluation document, Condition excludedCondition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        ConditionEvaluationResult conditionEvaluationResult = this.evaluateCondition.evaluate(collectionSequence, document, excludedCondition, environmentSnapshot);
        if (conditionEvaluationResult.isMatch()) {
            conditionEvaluationResult.getMatchedConditions().stream().forEach(mc -> this.markDocumentAsExcluded(document, mc.getReference()));
        }
    }

    private void markDocumentAsExcluded(DocumentUnderEvaluation documentUnderEvaluation, String reference) {
        if (documentUnderEvaluation.getReference() != null && documentUnderEvaluation.getReference().equals(reference)) {
            documentUnderEvaluation.setIsExcluded(true);
            return;
        }
        for (DocumentUnderEvaluation childDocumentUnderEvaluation : documentUnderEvaluation.getDocuments()) {
            this.markDocumentAsExcluded(childDocumentUnderEvaluation, reference);
        }
    }
}

