/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy;

import com.github.cafdataprocessing.corepolicy.common.ClassificationApi;
import com.github.cafdataprocessing.corepolicy.common.PolicyApi;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequenceEntry;
import com.github.cafdataprocessing.corepolicy.common.dto.DocumentCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.ExistsCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;

public class GenerateDemoContent {
    ClassificationApi classificationApi;
    PolicyApi policyApi;

    @Autowired
    public GenerateDemoContent(ClassificationApi classificationApi, PolicyApi policyApi) {
        this.classificationApi = classificationApi;
        this.policyApi = policyApi;
    }

    public Long createSimpleConditionSequence() throws CpeException {
        CollectionSequence simpleSequence = new CollectionSequence();
        simpleSequence.name = "Simple sequence";
        simpleSequence.description = "Contains a single Entry, with a single collection.";
        DocumentCollection simpleCollection = new DocumentCollection();
        simpleCollection.name = "Simple Collection";
        simpleCollection.description = "This collection has a single condition that will check for a field called \"content\"";
        ExistsCondition simpleCondition = new ExistsCondition();
        simpleCondition.name = "Content is present";
        simpleCondition.field = "content";
        simpleCollection.condition = simpleCondition;
        simpleCollection = this.classificationApi.create(simpleCollection);
        CollectionSequenceEntry simpleEntry = new CollectionSequenceEntry();
        simpleEntry.order = 100;
        simpleEntry.stopOnMatch = false;
        simpleEntry.collectionIds = new HashSet<Long>(Arrays.asList(simpleCollection.id));
        simpleSequence.collectionSequenceEntries = Arrays.asList(simpleEntry);
        simpleSequence = this.classificationApi.create(simpleSequence);
        return simpleSequence.id;
    }
}

