/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy;

import com.github.cafdataprocessing.corepolicy.ConditionEngine;
import com.github.cafdataprocessing.corepolicy.EnvironmentSnapshotCache;
import com.github.cafdataprocessing.corepolicy.PolicyEngine;
import com.github.cafdataprocessing.corepolicy.PolicyHandler;
import com.github.cafdataprocessing.corepolicy.ProcessingAction;
import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.ConditionEngineMetadata;
import com.github.cafdataprocessing.corepolicy.common.Document;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.PolicyApi;
import com.github.cafdataprocessing.corepolicy.common.dto.ClassifyDocumentResult;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionPolicy;
import com.github.cafdataprocessing.corepolicy.common.dto.ConditionEngineResult;
import com.github.cafdataprocessing.corepolicy.common.dto.ConflictResolutionMode;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCollection;
import com.github.cafdataprocessing.corepolicy.common.dto.Policy;
import com.github.cafdataprocessing.corepolicy.common.dto.PolicyType;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyEngineImpl
implements PolicyEngine {
    private final PolicyApi policyApi;
    private final EnvironmentSnapshotCache environmentSnapshotCache;
    private final ConditionEngine conditionEngine;
    private final ApiProperties apiProperties;
    private ConditionEngineMetadata conditionEngineMetadata;
    private final Collection<PolicyHandler> policyHandlers = new ArrayList<PolicyHandler>();
    private static Logger logger = LoggerFactory.getLogger(PolicyEngineImpl.class);

    @Autowired
    public PolicyEngineImpl(PolicyApi policyApi, EnvironmentSnapshotCache environmentSnapshotCache, ConditionEngine conditionEngine, ConditionEngineMetadata conditionEngineMetadata, ApiProperties apiProperties) {
        this.policyApi = policyApi;
        this.environmentSnapshotCache = environmentSnapshotCache;
        this.conditionEngine = conditionEngine;
        this.conditionEngineMetadata = conditionEngineMetadata;
        this.apiProperties = apiProperties;
    }

    @Override
    public EnvironmentSnapshot getEnvironmentSnapshot(long collectionSequenceId) {
        try {
            return this.environmentSnapshotCache.get(collectionSequenceId);
        }
        catch (CpeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    @Override
    public void invalidateCache(long collectionSequenceId) {
        this.environmentSnapshotCache.invalidate(collectionSequenceId);
    }

    @Override
    public void registerPolicyHandler(PolicyHandler policyHandler) {
        this.policyHandlers.add(policyHandler);
    }

    @Override
    public ClassifyDocumentResult classify(long collectionSequenceId, Document document) {
        DocumentUnderEvaluationImpl documentUnderEvaluation = new DocumentUnderEvaluationImpl(document, this.conditionEngineMetadata, this.apiProperties);
        documentUnderEvaluation.addMetadataString("POLICY_KV_METADATA_PRESENT", String.valueOf(document.getFullMetadata()));
        EnvironmentSnapshot environmentSnapshot = this.getEnvironmentSnapshot(collectionSequenceId);
        ConditionEngineResult conditionEngineResult = this.conditionEngine.evaluate(documentUnderEvaluation, collectionSequenceId, environmentSnapshot);
        ClassifyDocumentResult classifyResult = ClassifyDocumentResult.create((ConditionEngineResult)conditionEngineResult, (ConditionEngineMetadata)this.conditionEngineMetadata);
        classifyResult.resolvedPolicies = this.resolvePolicies(environmentSnapshot, document, conditionEngineResult);
        return classifyResult;
    }

    private Collection<Long> resolvePolicies(EnvironmentSnapshot environmentSnapshot, Document document, ConditionEngineResult conditionEngineResult) {
        ArrayList<Long> resolvedPolicies = new ArrayList<Long>();
        ArrayList collectionPolicies = new ArrayList();
        for (MatchedCollection matchedCollection : conditionEngineResult.matchedCollections) {
            collectionPolicies.addAll(matchedCollection.getPolicies());
        }
        Collection policyIds = collectionPolicies.stream().map(CollectionPolicy::getId).distinct().collect(Collectors.toList());
        Collection<Policy> policies = this.getPolicies(environmentSnapshot, policyIds);
        Collection distinctPolicyTypeIds = policies.stream().map(p -> p.typeId).distinct().collect(Collectors.toList());
        for (Long policyTypeId : distinctPolicyTypeIds) {
            Optional<PolicyHandler> policyHandler;
            PolicyType policyType = environmentSnapshot.getPolicyType(policyTypeId);
            Collection policiesOfType = policies.stream().filter(p -> p.typeId.equals(policyTypeId)).collect(Collectors.toList());
            if (policyType.conflictResolutionMode == null || policyType.conflictResolutionMode.equals((Object)ConflictResolutionMode.PRIORITY)) {
                Optional<Integer> highestPriority = policiesOfType.stream().map(p -> p.priority).max((p1, p2) -> p1 - p2);
                if (highestPriority.isPresent()) {
                    resolvedPolicies.addAll(policiesOfType.stream().filter(p -> p.priority.equals(highestPriority.get())).map(p -> p.id).collect(Collectors.toList()));
                    continue;
                }
                resolvedPolicies.addAll(policiesOfType.stream().map(p -> p.id).collect(Collectors.toList()));
                continue;
            }
            if (!policyType.conflictResolutionMode.equals((Object)ConflictResolutionMode.CUSTOM) || !(policyHandler = this.policyHandlers.stream().filter(ph -> ph.getPolicyTypeId() == policyTypeId.longValue()).findFirst()).isPresent()) continue;
            PolicyHandler policyHandler1 = policyHandler.get();
            resolvedPolicies.addAll(policyHandler1.resolve(document, policiesOfType).stream().map(p -> p.id).collect(Collectors.toList()));
        }
        return resolvedPolicies;
    }

    @Override
    public void execute(Long collectionSequenceId, Document document, Collection<Long> policyIds) {
        Collection<Policy> policies = null;
        if (collectionSequenceId != null) {
            EnvironmentSnapshot environmentSnapshot = this.getEnvironmentSnapshot(collectionSequenceId);
            policies = this.getPolicies(environmentSnapshot, policyIds);
        } else {
            policies = this.getPolicies(policyIds);
        }
        Collection distinctPolicyTypeIds = policies.stream().map(p -> p.typeId).distinct().collect(Collectors.toList());
        for (Long policyTypeId : distinctPolicyTypeIds) {
            Collection policiesOfType = policies.stream().filter(p -> p.typeId.equals(policyTypeId)).collect(Collectors.toList());
            Optional<PolicyHandler> policyHandler = this.policyHandlers.stream().filter(ph -> ph.getPolicyTypeId() == policyTypeId.longValue()).findFirst();
            if (policyHandler.isPresent()) {
                for (Policy policy : policiesOfType) {
                    ProcessingAction processingAction = policyHandler.get().handle(document, policy, collectionSequenceId);
                    if (processingAction != ProcessingAction.STOP_PROCESSING) continue;
                    return;
                }
                continue;
            }
            logger.debug("No handler registered for policy type id " + policyTypeId);
        }
    }

    private Collection<Policy> getPolicies(Collection<Long> policyIds) {
        return this.policyApi.retrievePolicies(policyIds);
    }

    private Collection<Policy> getPolicies(EnvironmentSnapshot environmentSnapshot, Collection<Long> policyIds) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (Long policyId : policyIds) {
            Policy policy = environmentSnapshot.getPolicy(policyId);
            if (policy == null) {
                throw new BackEndRequestFailedCpeException((Throwable)new RuntimeException(String.format("Policy id %s not found.", String.valueOf(policyId))));
            }
            policies.add(policy);
        }
        return policies;
    }
}

