/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.booleanagent;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpressionId;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public class BooleanAgentServicesBaseImpl {
    private final String startTagGuid = UUID.randomUUID().toString();
    private final String endTagGuid = UUID.randomUUID().toString();

    public String getStartTagGuid() {
        return this.startTagGuid;
    }

    public String getEndTagGuid() {
        return this.endTagGuid;
    }

    protected ArrayList<String> extractLinksFromHighlightedText(String highlightedText) {
        ArrayList<String> matchedStrings = new ArrayList<String>();
        int startIndex = 0;
        while ((startIndex = highlightedText.indexOf(this.getStartTagGuid(), startIndex)) != -1) {
            int endIndex = highlightedText.indexOf(this.getEndTagGuid(), startIndex);
            matchedStrings.add(highlightedText.substring(startIndex + this.getStartTagGuid().length(), endIndex));
            startIndex = endIndex;
        }
        return matchedStrings;
    }

    protected void extractTermsFromBooleanAgentDocument(String text, BooleanAgentQueryResult result, BooleanAgentDocument booleanAgentDocument) throws CpeException {
        block7: {
            block6: {
                Collection<String> links;
                if (booleanAgentDocument.getCondition_id() == null || booleanAgentDocument.getCondition_id().size() <= 0) break block6;
                Optional<String> conditionId = booleanAgentDocument.getCondition_id().stream().findFirst();
                if (!conditionId.isPresent() || (links = booleanAgentDocument.getLinks()) == null) break block7;
                for (String link : links) {
                    result.getConditionIdTerms().put((Object)Long.valueOf(conditionId.get()), (Object)link);
                }
                break block7;
            }
            if (booleanAgentDocument.getLexicon_id() != null && booleanAgentDocument.getLexicon_id().size() > 0) {
                Collection<String> links;
                Optional<String> lexiconExpressionIdString;
                LexiconExpressionId lexiconExpressionId = new LexiconExpressionId();
                Optional<String> lexiconId = booleanAgentDocument.getLexicon_id().stream().findFirst();
                if (lexiconId.isPresent()) {
                    lexiconExpressionId.lexiconId = Long.valueOf(lexiconId.get());
                }
                if ((lexiconExpressionIdString = booleanAgentDocument.getLexicon_expression_id().stream().findFirst()).isPresent()) {
                    lexiconExpressionId.lexiconExpressionId = Long.valueOf(lexiconExpressionIdString.get());
                }
                if ((links = booleanAgentDocument.getLinks()) != null) {
                    for (String link : links) {
                        result.getLexiconExpressionIdTerms().put((Object)lexiconExpressionId, (Object)link);
                    }
                }
            }
        }
    }
}

