/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.booleanagent;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResultImpl;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServicesBaseImpl;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanExpressionParser;
import com.github.cafdataprocessing.corepolicy.booleanagent.Term;
import com.github.cafdataprocessing.corepolicy.common.ElasticsearchProperties;
import com.github.cafdataprocessing.corepolicy.common.UserContext;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocument;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocuments;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.percolate.PercolateRequestBuilder;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateSourceBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.highlight.HighlightField;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public final class BooleanAgentServicesElasticImpl
extends BooleanAgentServicesBaseImpl
implements BooleanAgentServices,
DisposableBean {
    private static final String dbTypeName = "Activated";
    private static final String percolatorTypeName = ".percolator";
    private static final String booleanRestrictionFieldName = "BOOLEANRESTRICTION";
    private static final String contentFieldName = "DRECONTENT";
    private static final String referenceFieldName = "DREREFERENCE";
    private static final String dateFieldName = "DREDATE";
    private static final String dbFieldName = "DREDBNAME";
    private static final String projectIdFieldName = "project_id";
    private static final String instanceIdFieldName = "instance_id";
    private static final String conditionIdFieldName = "condition_id";
    private static final String lexiconIdFieldName = "lexicon_id";
    private static final String lexiconExpressionIdFieldName = "lexicon_expression_id";
    private static Logger logger = LoggerFactory.getLogger(BooleanAgentServicesElasticImpl.class);
    private BooleanExpressionParser parser;
    private ElasticsearchProperties elasticsearchProperties;
    private UserContext userContext;
    private String policyIndexName;
    private Client elasticClient;
    private boolean initialized = false;

    @Autowired
    public BooleanAgentServicesElasticImpl(ElasticsearchProperties elasticsearchProperties, UserContext userContext) {
        this.elasticsearchProperties = elasticsearchProperties;
        this.userContext = userContext;
        this.policyIndexName = elasticsearchProperties.getElasticsearchPolicyIndexName();
        this.parser = new BooleanExpressionParser(contentFieldName);
    }

    @Override
    public boolean getAvailable() {
        return !this.elasticsearchProperties.isElasticsearchDisabled();
    }

    @Override
    public BooleanAgentQueryResult query(String instanceId, Collection<MetadataValue> fieldValues) throws Exception {
        BooleanAgentQueryResultImpl booleanAgentQueryResult = new BooleanAgentQueryResultImpl();
        if (!fieldValues.isEmpty()) {
            try {
                this.initialize();
                MetadataValue.getStringValues(fieldValues).stream().filter(t -> !Strings.isNullOrEmpty((String)t)).forEach(t -> {
                    try {
                        this.queryBooleanAgents(instanceId, (String)t, booleanAgentQueryResult);
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                });
            }
            catch (IOException | UncheckedIOException e) {
                throw new BackEndRequestFailedCpeException(e.getCause());
            }
        }
        return booleanAgentQueryResult;
    }

    @Override
    public void create(String instanceId, BooleanAgentDocuments documents) throws CpeException {
        if (documents == null || documents.getDocuments() == null || documents.getDocuments().isEmpty()) {
            return;
        }
        try {
            this.initialize();
            for (BooleanAgentDocument booleanAgentDocument : documents.getDocuments()) {
                Optional<String> booleanRestriction = booleanAgentDocument.getBooleanRestriction().stream().findFirst();
                this.createStoredQuery(instanceId, this.getTtl(), booleanAgentDocument, booleanRestriction);
            }
        }
        catch (IOException e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    @Override
    public void delete(String instanceId) {
        try {
            String storedQueryId = this.getStoredQueryId(instanceId);
            if (storedQueryId != null) {
                this.getElasticClient().prepareDelete(this.policyIndexName, percolatorTypeName, storedQueryId).get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
            }
        }
        catch (IOException e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    @Override
    public boolean existForInstanceId(String instanceId) {
        return this.getStoredQueryId(instanceId) != null;
    }

    private String getStoredQueryId(String instanceId) {
        try {
            this.initialize();
            MatchQueryBuilder agentQueryBuilder = QueryBuilders.matchQuery((String)instanceIdFieldName, (Object)instanceId);
            SearchHits agentHits = ((SearchResponse)this.getElasticClient().prepareSearch(new String[]{this.policyIndexName}).setTypes(new String[]{percolatorTypeName}).setQuery((QueryBuilder)agentQueryBuilder).setSize(1).get(this.elasticsearchProperties.getElasticsearchSearchTimeout())).getHits();
            if (agentHits.getTotalHits() == 0L) {
                return null;
            }
            return agentHits.getAt(0).getId();
        }
        catch (IOException e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    @Override
    public void isValidExpression(String string) {
        try {
            XContentBuilder query = BooleanExpressionParser.wrapQuery(this.parseQuery(string));
            if (query != null) {
                this.initialize();
                ValidateQueryRequest validationRequest = new ValidateQueryRequest(new String[]{this.policyIndexName}).source(query);
                validationRequest.explain(true);
                ValidateQueryResponse validationResponse = (ValidateQueryResponse)this.getElasticClient().admin().indices().validateQuery(validationRequest).actionGet(this.elasticsearchProperties.getElasticsearchSearchTimeout());
                if (!validationResponse.isValid()) {
                    throw new RuntimeException(validationResponse.getQueryExplanation().stream().map(QueryExplanation::getError).collect(Collectors.joining(System.getProperty("line.separator"))));
                }
            }
        }
        catch (IOException e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    @Override
    public Collection<Term> doTermGetInfo(String text) {
        try {
            this.initialize();
            return this.getTerms(this.getTermVectors(text));
        }
        catch (IOException e) {
            throw new BackEndRequestFailedCpeException((Throwable)e);
        }
    }

    private TermVectorsResponse getTermVectors(String text) throws IOException {
        return (TermVectorsResponse)this.getElasticClient().prepareTermVectors().setIndex(this.policyIndexName).setType(percolatorTypeName).setDfs(true).setTermStatistics(true).setFieldStatistics(false).setPositions(true).setOffsets(true).setPayloads(false).setDoc(XContentFactory.jsonBuilder().startObject().field(booleanRestrictionFieldName, text).endObject()).get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
    }

    private Collection<Term> getTerms(TermVectorsResponse termVectorsResponse) throws IOException {
        ArrayList<Term> termInfos = new ArrayList<Term>();
        Fields fields = termVectorsResponse.getFields();
        if (fields != null) {
            for (String field : fields) {
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                TermsEnum termsIter = terms.iterator();
                while (termsIter.next() != null) {
                    termInfos.add(this.getTerm(termsIter));
                }
            }
        }
        return termInfos;
    }

    private Term getTerm(TermsEnum termsIter) throws IOException {
        Term termResult = new Term();
        termResult.setTermString(termsIter.term() == null ? null : termsIter.term().utf8ToString());
        termResult.setDocumentOccurrences(termsIter.docFreq());
        termResult.setTotalOccurrences((int)termsIter.totalTermFreq());
        this.setOffsets(termResult, termsIter);
        termResult.setApcmWeight(0);
        termResult.setTermCase(0);
        return termResult;
    }

    private void setOffsets(Term termResult, TermsEnum termsIter) throws IOException {
        PostingsEnum docsAndPositionsIter = termsIter.postings(null, 24);
        if (docsAndPositionsIter != null && docsAndPositionsIter.nextDoc() != Integer.MAX_VALUE && docsAndPositionsIter.freq() > 0 && docsAndPositionsIter.nextPosition() != -1 && docsAndPositionsIter.startOffset() != -1) {
            termResult.setStartPosition(docsAndPositionsIter.startOffset());
            if (docsAndPositionsIter.endOffset() != -1) {
                termResult.setLength(docsAndPositionsIter.endOffset() - docsAndPositionsIter.startOffset());
            }
        }
    }

    @Override
    public boolean canConnect() {
        try {
            this.initialize();
            return this.isIndexAvailable();
        }
        catch (Exception e) {
            logger.warn("Failed to verify an ability to connect to index \"{}\" in cluster \"{}\" in Elasticsearch at {}:{} due to error: ", new Object[]{this.policyIndexName, this.elasticsearchProperties.getElasticsearchClusterName(), this.elasticsearchProperties.getElasticsearchHost(), this.elasticsearchProperties.getElasticsearchPort(), e});
            return false;
        }
    }

    private boolean isIndexAvailable() throws UnknownHostException {
        return this.canGetSettings() && this.isClusterHealthy();
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            this.ensureIndex();
            this.initialized = true;
        }
    }

    private boolean canGetSettings() throws UnknownHostException {
        GetSettingsResponse indicesResponse = (GetSettingsResponse)((GetSettingsRequestBuilder)this.getElasticClient().admin().indices().prepareGetSettings(new String[]{this.policyIndexName}).setMasterNodeTimeout(this.elasticsearchProperties.getElasticsearchMasterNodeTimeout())).get();
        if (indicesResponse.getIndexToSettings().isEmpty()) {
            logger.warn("Failed to retrieve settings for the configured Elasticsearch index {}", (Object)this.policyIndexName);
            return false;
        }
        return true;
    }

    private boolean isClusterHealthy() throws UnknownHostException {
        ClusterHealthResponse healthResponse = (ClusterHealthResponse)this.getElasticClient().admin().cluster().prepareHealth(new String[]{this.policyIndexName}).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)this.elasticsearchProperties.getElasticsearchIndexStatusTimeout().intValue())).get();
        if (healthResponse.isTimedOut()) {
            logger.warn("Timed out while awaiting at least YELLOW status for Elasticsearch index {} ", (Object)this.policyIndexName);
            return false;
        }
        if (!healthResponse.getStatus().equals((Object)ClusterHealthStatus.YELLOW) && !healthResponse.getStatus().equals((Object)ClusterHealthStatus.GREEN)) {
            logger.warn("The Elasticsearch index {} is reporting status {}", (Object)this.policyIndexName, (Object)healthResponse.getStatus().name());
            return false;
        }
        return true;
    }

    private void ensureIndex() throws IOException {
        this.ensureIndex(true);
    }

    private void ensureIndex(boolean createIfAbsent) throws IOException {
        GetIndexResponse indexResponse = (GetIndexResponse)this.getElasticClient().admin().indices().prepareGetIndex().get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
        if (Arrays.asList(indexResponse.getIndices()).stream().anyMatch(i -> i.equalsIgnoreCase(this.policyIndexName))) {
            this.ensureIndexAvailable();
            return;
        }
        if (!createIfAbsent) {
            String error = MessageFormat.format("Failed to ensure that the index \"{0}\" exists in Elasticsearch", this.policyIndexName);
            logger.error(error);
            throw new RuntimeException(error);
        }
        logger.warn("Index \"{}\" does not exist in Elasticsearch. Creating index...", (Object)this.policyIndexName);
        try {
            this.createIndex();
        }
        catch (IndexAlreadyExistsException e) {
            logger.warn("Index \"{}\" was found to exist during creation attempt.", (Object)this.policyIndexName);
        }
        this.ensureIndex(false);
    }

    private void ensureIndexAvailable() throws UnknownHostException {
        int availabilityAttempt = 0;
        try {
            while (++availabilityAttempt <= this.elasticsearchProperties.getElasticsearchMaxIndexAvailabilityAttempts() && !this.isIndexAvailable()) {
                Thread.sleep(this.elasticsearchProperties.getElasticsearchIndexAvailabilityDelay().toStandardDuration().getMillis());
            }
        }
        catch (InterruptedException eInterrupted) {
            logger.warn("Interrupted while waiting to test the availability of the index \"{}\".", (Object)this.policyIndexName);
        }
    }

    private void createIndex() throws IOException {
        this.getElasticClient().admin().indices().prepareCreate(this.policyIndexName).addMapping(dbTypeName, XContentFactory.jsonBuilder().startObject().startObject(dbTypeName).startObject("properties").startObject(contentFieldName).field("type", "string").field("analyzer", "icu_analyzer").endObject().endObject().startObject("_ttl").field("enabled", "true").endObject().endObject().endObject()).addMapping(percolatorTypeName, XContentFactory.jsonBuilder().startObject().startObject(percolatorTypeName).startObject("_ttl").field("enabled", "true").endObject().startObject("properties").startObject(booleanRestrictionFieldName).field("type", "string").field("analyzer", "icu_analyzer").endObject().endObject().endObject().endObject()).setSettings(XContentFactory.jsonBuilder().startObject().startObject("analysis").startObject("analyzer").startObject("icu_analyzer").array("char_filter", new String[]{"icu_normalizer"}).field("tokenizer", "icu_tokenizer").endObject().endObject().endObject().endObject()).get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
    }

    private Client getElasticClient() throws UnknownHostException {
        if (this.elasticClient == null) {
            Settings settings = Settings.settingsBuilder().put("cluster.name", this.elasticsearchProperties.getElasticsearchClusterName()).put("client.transport.ping_timeout", this.elasticsearchProperties.getElasticsearchTransportPingTimeout()).build();
            this.elasticClient = TransportClient.builder().settings(settings).build().addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.elasticsearchProperties.getElasticsearchHost()), this.elasticsearchProperties.getElasticsearchPort().intValue()));
        }
        return this.elasticClient;
    }

    private String getTtl() {
        DateTime now = DateTime.now();
        DateTime expireTime = now.plus((ReadablePeriod)this.elasticsearchProperties.getAgentExpiry());
        return String.valueOf((expireTime.getMillis() - now.getMillis()) / 1000L) + "s";
    }

    private void createStoredQuery(String instanceId, String ttl, BooleanAgentDocument booleanAgentDocument, Optional<String> booleanRestriction) throws IOException {
        String reference = booleanAgentDocument.getReference() + "_" + instanceId;
        XContentBuilder storedQuery = this.prepareStoredQuery(instanceId, booleanAgentDocument, booleanRestriction, reference);
        this.getElasticClient().prepareIndex(this.policyIndexName, percolatorTypeName, reference).setSource(storedQuery).setRefresh(true).setTTL(ttl).get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
    }

    private XContentBuilder prepareStoredQuery(String instanceId, BooleanAgentDocument booleanAgentDocument, Optional<String> booleanRestriction, String queryReference) throws IOException {
        Optional<String> lexiconExpressionId;
        Optional<String> lexiconId;
        Optional<String> conditionId;
        XContentBuilder storedQueryBuilder = XContentFactory.jsonBuilder().startObject().field(referenceFieldName, queryReference).field(dateFieldName, new Date().getTime() / 1000L).field(dbFieldName, dbTypeName).field(projectIdFieldName, this.userContext.getProjectId() + "_" + instanceId).field(instanceIdFieldName, instanceId);
        if (booleanRestriction.isPresent()) {
            storedQueryBuilder = storedQueryBuilder.field(booleanRestrictionFieldName, booleanRestriction.get());
            QueryBuilder query = this.parseQuery(booleanRestriction.get());
            storedQueryBuilder = storedQueryBuilder.field("query", (ToXContent)query);
        }
        if (booleanAgentDocument.getCondition_id() != null && !booleanAgentDocument.getCondition_id().isEmpty() && (conditionId = booleanAgentDocument.getCondition_id().stream().findFirst()).isPresent()) {
            storedQueryBuilder = storedQueryBuilder.field(conditionIdFieldName, conditionId.get());
        }
        if (booleanAgentDocument.getLexicon_id() != null && !booleanAgentDocument.getLexicon_id().isEmpty() && (lexiconId = booleanAgentDocument.getLexicon_id().stream().findFirst()).isPresent()) {
            storedQueryBuilder = storedQueryBuilder.field(lexiconIdFieldName, lexiconId.get());
        }
        if (booleanAgentDocument.getLexicon_expression_id() != null && !booleanAgentDocument.getLexicon_expression_id().isEmpty() && (lexiconExpressionId = booleanAgentDocument.getLexicon_expression_id().stream().findFirst()).isPresent()) {
            storedQueryBuilder = storedQueryBuilder.field(lexiconExpressionIdFieldName, lexiconExpressionId.get());
        }
        return storedQueryBuilder.endObject();
    }

    private QueryBuilder parseQuery(String booleanRestriction) throws IOException {
        return this.parser.parse(booleanRestriction);
    }

    private void queryBooleanAgents(String instanceId, String textToQuery, BooleanAgentQueryResult booleanAgentQueryResult) throws IOException {
        PercolateResponse response = (PercolateResponse)((PercolateRequestBuilder)this.getElasticClient().preparePercolate().setIndices(new String[]{this.policyIndexName})).setDocumentType(dbTypeName).setPercolateDoc(PercolateSourceBuilder.docBuilder().setDoc(XContentFactory.jsonBuilder().startObject().field(contentFieldName, textToQuery).endObject())).setPercolateQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)projectIdFieldName, (Object)(this.userContext.getProjectId() + "_" + instanceId))).must((QueryBuilder)QueryBuilders.matchQuery((String)instanceIdFieldName, (Object)instanceId)))).setHighlightBuilder(new HighlightBuilder().field(contentFieldName).preTags(new String[]{this.getStartTagGuid()}).postTags(new String[]{this.getEndTagGuid()})).setSize(this.elasticsearchProperties.getElasticsearchMaxStoredqueryResults().intValue()).get(this.elasticsearchProperties.getElasticsearchSearchTimeout());
        List<BooleanAgentDocument> booleanAgentDocuments = this.convertToBooleanAgentDocuments(response);
        booleanAgentDocuments.forEach(d -> this.extractTermsFromBooleanAgentDocument(textToQuery, booleanAgentQueryResult, (BooleanAgentDocument)d));
    }

    private List<BooleanAgentDocument> convertToBooleanAgentDocuments(PercolateResponse response) throws UnknownHostException {
        Collection<AgentResult> agents = this.getAgents(response);
        return agents.stream().map(this::convertToBooleanAgentDocument).collect(Collectors.toList());
    }

    private Collection<AgentResult> getAgents(PercolateResponse response) throws UnknownHostException {
        HashMap<String, AgentResult> indexedAgents = new HashMap<String, AgentResult>();
        BoolQueryBuilder agentsQueryBuilder = QueryBuilders.boolQuery();
        for (Object match : response) {
            String agentId = match.getId().string();
            agentsQueryBuilder = agentsQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)agentId));
            indexedAgents.put(agentId, new AgentResult(agentId, (PercolateResponse.Match)match, null));
        }
        SearchHits agentHits = ((SearchResponse)this.getElasticClient().prepareSearch(new String[]{this.policyIndexName}).setTypes(new String[]{percolatorTypeName}).setQuery((QueryBuilder)agentsQueryBuilder).setSize(this.elasticsearchProperties.getElasticsearchMaxStoredqueries().intValue()).get(this.elasticsearchProperties.getElasticsearchSearchTimeout())).getHits();
        for (SearchHit agentHit : agentHits) {
            AgentResult agentResult = (AgentResult)indexedAgents.get(agentHit.getId());
            if (agentResult == null) continue;
            agentResult.setSource(agentHit.sourceAsMap());
        }
        if (indexedAgents.values().stream().anyMatch(r -> r.getSource() == null)) {
            String error = "Failed to retrieve all the expected boolean agents from Elasticsearch";
            logger.error(error);
            throw new RuntimeException(error);
        }
        return indexedAgents.values();
    }

    private BooleanAgentDocument convertToBooleanAgentDocument(AgentResult agentResult) {
        BooleanAgentDocument booleanAgentDocument = new BooleanAgentDocument();
        Map<String, Object> agentSource = agentResult.getSource();
        if (!agentSource.containsKey(booleanRestrictionFieldName)) {
            String error = MessageFormat.format("Failed to retrieve boolean restriction of agent with id \"{0}\" in Elasticsearch", agentResult.getAgentId());
            logger.error(error);
            throw new RuntimeException(error);
        }
        booleanAgentDocument.setBooleanRestriction(Collections.singletonList(agentSource.get(booleanRestrictionFieldName)).stream().map(String::valueOf).collect(Collectors.toList()));
        if (agentSource.containsKey(conditionIdFieldName)) {
            booleanAgentDocument.setCondition_id(Collections.singletonList(agentSource.get(conditionIdFieldName)).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if (agentSource.containsKey(lexiconIdFieldName)) {
            booleanAgentDocument.setLexicon_id(Collections.singletonList(agentSource.get(lexiconIdFieldName)).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        if (agentSource.containsKey(lexiconExpressionIdFieldName)) {
            booleanAgentDocument.setLexicon_expression_id(Collections.singletonList(agentSource.get(lexiconExpressionIdFieldName)).stream().map(String::valueOf).collect(Collectors.toList()));
        }
        booleanAgentDocument.setLinks(this.getHighlightLinks(agentResult.getMatch()));
        return booleanAgentDocument;
    }

    private Collection<String> getHighlightLinks(PercolateResponse.Match match) {
        ArrayList<String> highlightTerms = new ArrayList<String>();
        Map highlightFields = match.getHighlightFields();
        if (highlightFields != null) {
            HighlightField highlightedContentField = (HighlightField)highlightFields.get(contentFieldName);
            for (Text fragment : highlightedContentField.getFragments()) {
                highlightTerms.addAll(this.extractLinksFromHighlightedText(fragment.string()));
            }
        }
        return highlightTerms.stream().distinct().collect(Collectors.toList());
    }

    public void destroy() throws Exception {
        if (this.elasticClient != null) {
            this.elasticClient.close();
            this.elasticClient = null;
        }
    }

    private class AgentResult {
        private String agentId;
        private PercolateResponse.Match match;
        private Map<String, Object> source;

        public AgentResult(String agentId, PercolateResponse.Match match, Map<String, Object> source) {
            this.agentId = agentId;
            this.match = match;
            this.source = source;
        }

        public String getAgentId() {
            return this.agentId;
        }

        public PercolateResponse.Match getMatch() {
            return this.match;
        }

        public Map<String, Object> getSource() {
            return this.source;
        }

        public void setSource(Map<String, Object> source) {
            this.source = source;
        }
    }
}

