/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.booleanagent;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanExpressionTokenizer;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class BooleanExpressionParser {
    private String literalFieldName;
    private BooleanExpressionTokenizer tokenizer;
    private Stack<BooleanExpressionTokenizer.Token> operators = new Stack();
    private Stack<Node> operands = new Stack();
    private BooleanExpressionTokenizer.Token SENTINEL = BooleanExpressionTokenizer.END;

    public static XContentBuilder wrapQuery(QueryBuilder query) throws IOException {
        if (query == null) {
            return null;
        }
        XContentBuilder wrappedQuery = XContentFactory.jsonBuilder();
        wrappedQuery.startObject();
        wrappedQuery.field("query", (ToXContent)query);
        wrappedQuery.endObject();
        return wrappedQuery;
    }

    public BooleanExpressionParser(String literalFieldName) {
        this.literalFieldName = literalFieldName;
    }

    public QueryBuilder parse(String expression) throws IOException {
        if (expression == null) {
            return null;
        }
        this.tokenizer = new BooleanExpressionTokenizer(expression);
        this.operators.push(this.SENTINEL);
        this.parseExpression();
        this.expect(BooleanExpressionTokenizer.END);
        return this.operands.peek().getQuery();
    }

    private void expect(BooleanExpressionTokenizer.Token token) throws IOException {
        if (this.tokenizer.next() == token) {
            this.tokenizer.consume();
            return;
        }
        String error = MessageFormat.format("Unexpected token. Expected \"{0}\" but encountered \"{1}\"{2}.", token.getClass().getSimpleName().toLowerCase(), this.tokenizer.next().getClass().getSimpleName().toLowerCase(), this.tokenizer.next() instanceof BooleanExpressionTokenizer.Literal ? MessageFormat.format(" with value \"{0}\"", ((BooleanExpressionTokenizer.Literal)this.tokenizer.next()).getValue()) : "");
        throw new RuntimeException(error);
    }

    private void expect(Class<? extends BooleanExpressionTokenizer.Token> tokenClazz) throws IOException {
        if (this.tokenizer.next().getClass().equals(tokenClazz)) {
            this.tokenizer.consume();
            return;
        }
        String error = MessageFormat.format("Unexpected token. Expected \"{0}\" but encountered \"{1}\"{2}.", tokenClazz.getSimpleName().toLowerCase(), this.tokenizer.next().getClass().getSimpleName().toLowerCase(), this.tokenizer.next() instanceof BooleanExpressionTokenizer.Literal ? MessageFormat.format(" with value \"{0}\"", ((BooleanExpressionTokenizer.Literal)this.tokenizer.next()).getValue()) : "");
        throw new RuntimeException(error);
    }

    private void parseExpression() throws IOException {
        this.parseTerm();
        while (this.tokenizer.next() instanceof BooleanExpressionTokenizer.BinaryOperator) {
            this.pushOperator(this.tokenizer.next());
            this.tokenizer.consume();
            this.parseTerm();
        }
        while (this.operators.peek() != this.SENTINEL) {
            this.popOperator();
        }
    }

    private void parseTerm() throws IOException {
        if (this.tokenizer.next() instanceof BooleanExpressionTokenizer.Literal) {
            this.operands.push(this.makeLeaf(this.tokenizer.next()));
            this.tokenizer.consume();
        } else if (this.tokenizer.next() instanceof BooleanExpressionTokenizer.OpenParenthesis) {
            this.tokenizer.consume();
            this.operators.push(this.SENTINEL);
            this.parseExpression();
            this.expect(BooleanExpressionTokenizer.CloseParenthesis.class);
            this.operators.pop();
        } else if (this.tokenizer.next() instanceof BooleanExpressionTokenizer.UnaryOperator) {
            this.pushOperator(this.tokenizer.next());
            this.tokenizer.consume();
            this.parseTerm();
        } else {
            String error = MessageFormat.format("Term parsing found an unexpected token. Expected \"literal\", \"openparenthesis\", or \"unaryoperator\" but encountered \"{0}\".", this.tokenizer.next().getClass().getSimpleName().toLowerCase());
            throw new RuntimeException(error);
        }
    }

    private void popOperator() {
        if (this.operators.peek() instanceof BooleanExpressionTokenizer.BinaryOperator) {
            Node term2 = this.operands.pop();
            Node term1 = this.operands.pop();
            this.operands.push(this.makeNode(this.operators.pop(), term1, term2));
        } else {
            this.operands.push(this.makeNode(this.operators.pop(), this.operands.pop()));
        }
    }

    private void pushOperator(BooleanExpressionTokenizer.Token operator) {
        while (this.operators.peek().precedence() > operator.precedence()) {
            this.popOperator();
        }
        this.operators.push(operator);
    }

    private Node makeLeaf(BooleanExpressionTokenizer.Token token) {
        return this.makeNode(token, new Node[0]);
    }

    private Node makeNode(BooleanExpressionTokenizer.Token token, Node ... terms) {
        return new Node(token, terms);
    }

    private class Node {
        private BooleanExpressionTokenizer.Token token;
        private List<Node> childNodes = new ArrayList<Node>();
        private QueryBuilder query;

        public Node(BooleanExpressionTokenizer.Token token, Node ... children) {
            this.token = token;
            for (Node child : children) {
                this.childNodes.add(child);
            }
        }

        public QueryBuilder getQuery() {
            if (this.query == null) {
                this.buildQuery();
            }
            return this.query;
        }

        private void buildQuery() {
            if (this.token instanceof BooleanExpressionTokenizer.WildcardLiteral) {
                this.query = QueryBuilders.queryStringQuery((String)((BooleanExpressionTokenizer.Literal)this.token).getValue()).analyzeWildcard(true);
                return;
            }
            if (this.token instanceof BooleanExpressionTokenizer.Literal) {
                this.query = QueryBuilders.matchPhraseQuery((String)BooleanExpressionParser.this.literalFieldName, (Object)((BooleanExpressionTokenizer.Literal)this.token).getValue());
                return;
            }
            if (this.token instanceof BooleanExpressionTokenizer.Or) {
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                this.childNodes.forEach(n -> boolQuery.should(n.getQuery()));
                this.query = boolQuery;
                return;
            }
            if (this.token instanceof BooleanExpressionTokenizer.And) {
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                this.childNodes.forEach(n -> boolQuery.must(n.getQuery()));
                this.query = boolQuery;
                return;
            }
            if (this.token instanceof BooleanExpressionTokenizer.Not) {
                if (this.childNodes.size() != 1) {
                    throw new RuntimeException("Encountered a \"not\" operator that does not have exactly one operand.");
                }
                this.query = QueryBuilders.boolQuery().mustNot(this.childNodes.get(0).getQuery());
                return;
            }
            if (this.token instanceof BooleanExpressionTokenizer.Proximity) {
                if (this.childNodes.stream().anyMatch(n -> !(n.token instanceof BooleanExpressionTokenizer.Literal))) {
                    throw new RuntimeException("Encountered a proximity operator with a non-literal operand.");
                }
                String concatenatedLiterals = this.childNodes.stream().map(n -> ((BooleanExpressionTokenizer.Literal)n.token).getValue()).collect(Collectors.joining(" "));
                this.query = QueryBuilders.matchPhraseQuery((String)BooleanExpressionParser.this.literalFieldName, (Object)concatenatedLiterals).slop(((BooleanExpressionTokenizer.Proximity)this.token).getDistance());
                return;
            }
            String error = MessageFormat.format("Query building found an unexpected token. Expected \"literal\", \"or\", \"and\", \"not\", or \"proximity\" but encountered \"{0}\".", this.token.getClass().getSimpleName().toLowerCase());
            throw new RuntimeException(error);
        }
    }
}

