/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.booleanagent;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BooleanExpressionTokenizer {
    private String expression;
    private PushbackReader reader;
    private Token nextToken;
    private Token futureToken;
    public static final Token END = new End();
    private static Pattern proximityPattern = Pattern.compile("^/(\\d*)$");
    private static Pattern wildcardPattern = Pattern.compile("[?*]");

    public BooleanExpressionTokenizer(String expression) {
        this.expression = expression;
        this.reader = new PushbackReader(new StringReader(expression));
    }

    public Token next() throws IOException {
        while (this.nextToken == null) {
            this.nextToken = this.futureToken;
            this.futureToken = this.readNextToken();
            if (!(this.nextToken instanceof Literal)) continue;
            while (this.futureToken instanceof Literal) {
                ((Literal)this.nextToken).append((Literal)this.futureToken);
                this.futureToken = this.readNextToken();
            }
        }
        return this.nextToken;
    }

    public void consume() {
        if (this.nextToken != END) {
            this.nextToken = null;
        }
    }

    private Token readNextToken() throws IOException {
        int nextCh = this.reader.read();
        while (nextCh != -1 && Character.isWhitespace(nextCh)) {
            nextCh = this.reader.read();
        }
        if (nextCh == -1) {
            return END;
        }
        if ((char)nextCh == '(') {
            return new OpenParenthesis();
        }
        if ((char)nextCh == ')') {
            return new CloseParenthesis();
        }
        String token = this.readTokenText(nextCh);
        switch (token.toLowerCase()) {
            case "and": {
                return new And();
            }
            case "or": {
                return new Or();
            }
            case "not": {
                return new Not();
            }
        }
        String proximity = this.getProximity(token);
        if (proximity != null) {
            return new Proximity(Integer.parseInt(proximity));
        }
        if (this.containsWildcards(token)) {
            return new WildcardLiteral(token);
        }
        return new Literal(token);
    }

    private boolean containsWildcards(String token) {
        Matcher matcher = wildcardPattern.matcher(token);
        return matcher.find();
    }

    private String readTokenText(int nextCh) throws IOException {
        if ((char)nextCh == '\"') {
            return this.readQuotedString(nextCh);
        }
        StringBuilder text = new StringBuilder();
        while (nextCh != -1 && !Character.isWhitespace(nextCh) && (char)nextCh != '(' && (char)nextCh != ')' && (char)nextCh != '\"') {
            text.append((char)nextCh);
            nextCh = this.reader.read();
        }
        if ((char)nextCh == '(' || (char)nextCh == ')' || (char)nextCh == '\"') {
            this.reader.unread(nextCh);
        }
        return text.toString();
    }

    private String readQuotedString(int nextCh) throws IOException {
        if (nextCh != -1 && (char)nextCh == '\"') {
            nextCh = this.reader.read();
        }
        StringBuilder text = new StringBuilder();
        while (nextCh != -1 && (char)nextCh != '\"') {
            text.append((char)nextCh);
            nextCh = this.reader.read();
        }
        if (nextCh == -1) {
            String error = MessageFormat.format("No closing quote was found for the quoted string: \"{0}", text);
            throw new RuntimeException(error);
        }
        return text.toString();
    }

    private String getProximity(String text) {
        if (text.startsWith("/")) {
            Matcher matcher = proximityPattern.matcher(text);
            if (matcher.find()) {
                return matcher.group(1);
            }
            String error = MessageFormat.format("Tokenizer found an invalid proximity operator: \"{0}\".", text);
            throw new RuntimeException(error);
        }
        return null;
    }

    public static class WildcardLiteral
    extends Literal {
        public WildcardLiteral(String value) {
            super(value);
        }
    }

    public static class Literal
    extends Token {
        private String value;

        public Literal(String value) {
            this.value = value;
        }

        @Override
        public int precedence() {
            return 1;
        }

        public String getValue() {
            return this.value;
        }

        public Literal append(Literal other) {
            this.value = this.value + ' ' + other.getValue();
            return this;
        }
    }

    public static class OpenParenthesis
    extends Parenthesis {
    }

    public static class CloseParenthesis
    extends Parenthesis {
    }

    public static class Parenthesis
    extends Token {
        @Override
        public int precedence() {
            return 6;
        }
    }

    public static class Not
    extends UnaryOperator {
        @Override
        public int precedence() {
            return 5;
        }
    }

    public static class And
    extends BinaryOperator {
        @Override
        public int precedence() {
            return 4;
        }
    }

    public static class Or
    extends BinaryOperator {
        @Override
        public int precedence() {
            return 3;
        }
    }

    public static class Proximity
    extends BinaryOperator {
        private int distance;

        public Proximity(int distance) {
            this.distance = distance;
        }

        @Override
        public int precedence() {
            return 2;
        }

        public int getDistance() {
            return this.distance;
        }
    }

    public static abstract class UnaryOperator
    extends Operator {
    }

    public static abstract class BinaryOperator
    extends Operator {
    }

    public static abstract class Operator
    extends Token {
    }

    public static class End
    extends Token {
        @Override
        public int precedence() {
            return 0;
        }
    }

    public static abstract class Token {
        public abstract int precedence();
    }
}

