/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.booleanagent;

import com.github.cafdataprocessing.corepolicy.booleanagent.ConditionToBooleanAgentConverter;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpression;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.TextCondition;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocument;
import com.github.cafdataprocessing.corepolicy.domainModels.BooleanAgentDocuments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.stereotype.Component;

@Component
public class ConditionToBooleanAgentConverterImpl
implements ConditionToBooleanAgentConverter {
    @Override
    public BooleanAgentDocuments convert(Collection<TextCondition> contentExpressionConditions, Collection<LexiconExpression> lexiconExpressions) {
        BooleanAgentDocument document;
        BooleanAgentDocuments addToTextIndexDocuments = new BooleanAgentDocuments();
        ArrayList<BooleanAgentDocument> documents = new ArrayList<BooleanAgentDocument>();
        addToTextIndexDocuments.setDocuments(documents);
        if (contentExpressionConditions != null) {
            for (TextCondition contentExpressionCondition : contentExpressionConditions) {
                document = new BooleanAgentDocument();
                document.setReference(String.valueOf(contentExpressionCondition.id));
                document.setBooleanRestriction(Arrays.asList(String.valueOf(contentExpressionCondition.value)));
                document.setCondition_id(Arrays.asList(String.valueOf(contentExpressionCondition.id)));
                documents.add(document);
            }
        }
        if (lexiconExpressions != null) {
            for (LexiconExpression lexiconExpression : lexiconExpressions) {
                document = new BooleanAgentDocument();
                document.setReference(String.valueOf(lexiconExpression.lexiconId) + "_" + lexiconExpression.id);
                document.setBooleanRestriction(Arrays.asList(String.valueOf(lexiconExpression.expression)));
                document.setLexicon_id(Arrays.asList(String.valueOf(lexiconExpression.lexiconId)));
                document.setLexicon_expression_id(Arrays.asList(String.valueOf(lexiconExpression.id)));
                documents.add(document);
            }
        }
        return addToTextIndexDocuments;
    }
}

