/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnevaluatedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnmatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.BooleanCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.BooleanOperator;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluatorBase;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.EvaluateCondition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="BooleanCondition")
class BooleanConditionEvaluator
extends ConditionEvaluatorBase<BooleanCondition> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanConditionEvaluator.class);
    private EvaluateCondition evaluateCondition;

    @Autowired
    public BooleanConditionEvaluator(EvaluateCondition evaluateCondition) {
        this.evaluateCondition = evaluateCondition;
    }

    @Override
    protected void evaluate(CollectionSequence collectionSequence, ConditionEvaluationResult result, DocumentUnderEvaluation document, BooleanCondition condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        List conditions = condition.children;
        BooleanOperator operator = condition.operator;
        if (conditions.size() == 0) {
            MatchedCondition matchedCondition = new MatchedCondition(document.getReference(), (Condition)condition);
            result.populateEvaluationResult(true, Arrays.asList(matchedCondition), null, null, Arrays.asList(matchedCondition), false);
            return;
        }
        ArrayList<MatchedCondition> matchedConditions = new ArrayList<MatchedCondition>();
        ArrayList<UnmatchedCondition> unmatchedConditions = new ArrayList<UnmatchedCondition>();
        ArrayList<UnevaluatedCondition> unevaluatedConditions = new ArrayList<UnevaluatedCondition>();
        ArrayList<MatchedCondition> allConditionMatches = new ArrayList<MatchedCondition>();
        boolean foundMatch = false;
        for (Condition containedCondition : conditions) {
            ConditionEvaluationResult containedConditionResult = this.evaluateCondition.evaluate(collectionSequence, document, containedCondition, environmentSnapshot);
            unmatchedConditions.addAll(containedConditionResult.getUnmatchedConditions());
            unevaluatedConditions.addAll(containedConditionResult.getUnevaluatedConditions());
            allConditionMatches.addAll(containedConditionResult.getAllConditionMatches());
            if (operator == BooleanOperator.AND && !containedConditionResult.isMatch()) {
                foundMatch = false;
                break;
            }
            if (containedConditionResult.isMatch()) {
                foundMatch = true;
                matchedConditions.addAll(containedConditionResult.getMatchedConditions());
            }
            if (operator != BooleanOperator.OR || !foundMatch || collectionSequence.fullConditionEvaluation.booleanValue()) continue;
            break;
        }
        if (foundMatch) {
            MatchedCondition matchedCondition = new MatchedCondition(document.getReference(), (Condition)condition);
            matchedConditions.add(matchedCondition);
            allConditionMatches.add(matchedCondition);
        } else if (unevaluatedConditions.size() == 0) {
            unmatchedConditions.add(new UnmatchedCondition(document.getReference(), (Condition)condition));
        }
        result.populateEvaluationResult(foundMatch, matchedConditions, unmatchedConditions, unevaluatedConditions, allConditionMatches, false);
    }
}

