/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnevaluatedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnmatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.Collection;
import java.util.HashSet;

public class ConditionEvaluationResult {
    private boolean match = false;
    private Collection<UnevaluatedCondition> unevaluatedConditions = new HashSet<UnevaluatedCondition>();
    private Collection<MatchedCondition> matchedConditions = new HashSet<MatchedCondition>();
    private Collection<UnmatchedCondition> unmatchedConditions;
    private Collection<MatchedCondition> allConditionMatches = new HashSet<MatchedCondition>();

    public ConditionEvaluationResult() {
        this.unmatchedConditions = new HashSet<UnmatchedCondition>();
    }

    public Collection<UnevaluatedCondition> getUnevaluatedConditions() {
        return this.unevaluatedConditions;
    }

    public boolean isMatch() {
        return this.match;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public Collection<MatchedCondition> getMatchedConditions() {
        return this.matchedConditions;
    }

    public Collection<UnmatchedCondition> getUnmatchedConditions() {
        return this.unmatchedConditions;
    }

    public Collection<MatchedCondition> getAllConditionMatches() {
        return this.allConditionMatches;
    }

    void populateEvaluationResult(boolean isMatch, Condition condition, DocumentUnderEvaluation document, boolean mergeResult) {
        this.populateEvaluationResult(isMatch, condition, document, null, mergeResult);
    }

    void populateEvaluationResult(boolean isMatch, Condition condition, DocumentUnderEvaluation document, Collection<String> termMatches, boolean mergeResult) {
        if (!mergeResult) {
            this.setMatch(isMatch);
        } else if (isMatch) {
            this.setMatch(isMatch);
        }
        if (isMatch) {
            MatchedCondition matchedCondition = new MatchedCondition(document.getReference(), condition);
            if (termMatches != null && termMatches.size() > 0) {
                matchedCondition.getTerms().addAll(termMatches);
            }
            this.getMatchedConditions().add(matchedCondition);
            this.getAllConditionMatches().add(matchedCondition);
        } else {
            this.getUnmatchedConditions().add(new UnmatchedCondition(document.getReference(), condition));
        }
    }

    void populateEvaluationResult(MatchedCondition condition) {
        this.setMatch(true);
        this.getMatchedConditions().add(condition);
        this.getAllConditionMatches().add(condition);
    }

    void populateEvaluationResult(ConditionEvaluationResult tempConditionEvaluationResult, boolean mergeResult) {
        this.populateEvaluationResult(tempConditionEvaluationResult.isMatch(), tempConditionEvaluationResult.getMatchedConditions(), tempConditionEvaluationResult.getUnmatchedConditions(), tempConditionEvaluationResult.getUnevaluatedConditions(), tempConditionEvaluationResult.getAllConditionMatches(), mergeResult);
    }

    void populateEvaluationResult(ConditionEvaluationResult tempConditionEvaluationResult) {
        this.populateEvaluationResult(tempConditionEvaluationResult, true);
    }

    void populateEvaluationResult(boolean isMatch, Collection<MatchedCondition> matchedConditions, Collection<UnmatchedCondition> unmatchedConditions, Collection<UnevaluatedCondition> unevaluatedConditions, Collection<MatchedCondition> allConditionMatches, boolean mergeResult) {
        if (!mergeResult) {
            this.setMatch(isMatch);
        } else if (isMatch) {
            this.setMatch(isMatch);
        }
        if (isMatch && matchedConditions != null) {
            this.getMatchedConditions().addAll(matchedConditions);
        }
        if (allConditionMatches != null) {
            this.getAllConditionMatches().addAll(allConditionMatches);
        }
        if (unmatchedConditions != null) {
            this.getUnmatchedConditions().addAll(unmatchedConditions);
        }
        if (unevaluatedConditions != null) {
            this.getUnevaluatedConditions().addAll(unevaluatedConditions);
        }
    }
}

