/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.UnmatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.ConditionTarget;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FragmentCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.BooleanConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.CachedConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConditionEvaluatorBase<T extends Condition>
implements ConditionEvaluator<T> {
    private static final Logger logger = LoggerFactory.getLogger(BooleanConditionEvaluator.class);

    @Override
    public ConditionEvaluationResult evaluate(CollectionSequence collectionSequence, DocumentUnderEvaluation documentUnderEvaluation, T condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        ConditionEvaluationResult conditionEvaluationResult = new ConditionEvaluationResult();
        if (documentUnderEvaluation.hasConditionBeenEvaluatedThisRun(((Condition)condition).id).booleanValue()) {
            CachedConditionEvaluationResult conditionEvaluationResultMatch = documentUnderEvaluation.getConditionEvaluationResult(((Condition)condition).id);
            if (conditionEvaluationResultMatch != null) {
                conditionEvaluationResult.setMatch(conditionEvaluationResultMatch.isMatch());
                if (conditionEvaluationResultMatch.isMatch()) {
                    conditionEvaluationResult.getAllConditionMatches().add(conditionEvaluationResultMatch.getMatchedCondition());
                    conditionEvaluationResult.getMatchedConditions().add(conditionEvaluationResultMatch.getMatchedCondition());
                } else {
                    conditionEvaluationResult.getUnmatchedConditions().add(conditionEvaluationResultMatch.getUnmatchedCondition());
                }
            }
            return conditionEvaluationResult;
        }
        Collection<DocumentUnderEvaluation> itemsToCheck = this.getItemsToCheck(documentUnderEvaluation, (Condition)condition);
        for (DocumentUnderEvaluation itemToCheck : itemsToCheck) {
            ConditionEvaluationResult tempConditionEvaluationResult = new ConditionEvaluationResult();
            this.evaluate(collectionSequence, tempConditionEvaluationResult, itemToCheck, condition, environmentSnapshot);
            conditionEvaluationResult.populateEvaluationResult(tempConditionEvaluationResult, true);
            if (condition instanceof FragmentCondition) {
                logger.debug("Skipping cache of FragmentCondition ID: " + ((Condition)condition).id);
            } else {
                itemToCheck.addConditionEvaluationResult(tempConditionEvaluationResult, ((Condition)condition).id);
            }
            itemToCheck.setConditionHasBeenEvaluatedThisRun(((Condition)condition).id);
        }
        return conditionEvaluationResult;
    }

    private Collection<DocumentUnderEvaluation> getItemsToCheck(DocumentUnderEvaluation documentUnderEvaluation, Condition condition) {
        LinkedList<DocumentUnderEvaluation> documents = new LinkedList<DocumentUnderEvaluation>();
        if (condition.target == null || condition.target == ConditionTarget.ALL || condition.target == ConditionTarget.CONTAINER && !documentUnderEvaluation.getIsExcluded().booleanValue()) {
            documents.add(documentUnderEvaluation);
        }
        if (condition.target == ConditionTarget.ALL || condition.target == ConditionTarget.CHILDREN) {
            documents.addAll(this.getChildren(documentUnderEvaluation, condition.includeDescendants));
        }
        return documents;
    }

    private Collection<DocumentUnderEvaluation> getChildren(DocumentUnderEvaluation documentUnderEvaluation, boolean includeDescendiants) {
        if (documentUnderEvaluation.getDocuments().isEmpty()) {
            return new LinkedList<DocumentUnderEvaluation>();
        }
        Collection documents = documentUnderEvaluation.getDocuments().stream().filter(u -> u.getIsExcluded() == false).collect(Collectors.toList());
        if (includeDescendiants) {
            LinkedList<DocumentUnderEvaluation> childDocuments = new LinkedList<DocumentUnderEvaluation>();
            for (DocumentUnderEvaluation descendiant : documents) {
                childDocuments.addAll(this.getChildren(descendiant, true));
            }
            documents.addAll(childDocuments);
        }
        return documents;
    }

    protected abstract void evaluate(CollectionSequence var1, ConditionEvaluationResult var2, DocumentUnderEvaluation var3, T var4, EnvironmentSnapshot var5) throws CpeException;

    protected boolean checkForCachedEvaluationResults(ConditionEvaluationResult result, DocumentUnderEvaluation document, Condition condition) {
        CachedConditionEvaluationResult conditionEvaluationResultMatch = document.getConditionEvaluationResult(condition.id);
        if (conditionEvaluationResultMatch != null) {
            result.setMatch(conditionEvaluationResultMatch.isMatch());
            if (conditionEvaluationResultMatch.isMatch()) {
                MatchedCondition matchedCondition = conditionEvaluationResultMatch.getMatchedCondition();
                result.getMatchedConditions().add(matchedCondition);
                result.getAllConditionMatches().add(matchedCondition);
            } else {
                UnmatchedCondition umc = conditionEvaluationResultMatch.getUnmatchedCondition();
                if (umc == null) {
                    return false;
                }
                result.getUnmatchedConditions().add(umc);
            }
            return true;
        }
        return false;
    }
}

