/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.common.EngineProperties;
import com.github.cafdataprocessing.corepolicy.common.IsoToLanguageEnumConverter;
import com.github.cafdataprocessing.corepolicy.common.LanguagesEnum;
import com.github.cafdataprocessing.corepolicy.common.MatcherWithTimeout;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.RegexMatcherFactory;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentExpressionHelper {
    private RegexMatcherFactory matcherFactory;
    private final EngineProperties engineProperties;
    private static Pattern chinesePattern = Pattern.compile("\\p{IsHan}");
    private static Pattern thaiPattern = Pattern.compile("\\p{IsThai}");
    private static Pattern koreanPattern = Pattern.compile("\\p{IsHangul}|\\p{IsHan}");
    private static Pattern japanesePattern = Pattern.compile("\\p{IsHan}|\\p{IsHiragana}|\\p{IsKatakana}");

    @Autowired
    public ContentExpressionHelper(RegexMatcherFactory matcherFactory, EngineProperties engineProperties) {
        this.matcherFactory = matcherFactory;
        this.engineProperties = engineProperties;
    }

    public BooleanAgentQueryResult handleBooleanAgentExpression(String instanceId, BooleanAgentServices booleanAgentServices, DocumentUnderEvaluation document, String fieldName, String languageCode) throws CpeException {
        LanguagesEnum languagesEnum = null;
        if (languageCode != null) {
            languagesEnum = IsoToLanguageEnumConverter.convert((String)languageCode.toLowerCase());
        }
        LanguagesEnum finalLanguagesEnum = languagesEnum;
        Collection returnedFieldValues = this.getFieldValues(document, fieldName).stream().filter(fv -> this.isValidForLanguage(finalLanguagesEnum, (MetadataValue)fv)).collect(Collectors.toList());
        BooleanAgentQueryResult booleanAgentQueryResult = languagesEnum == null ? document.getBooleanAgentQueryResult(fieldName) : document.getBooleanAgentQueryResult(fieldName, languagesEnum);
        if (booleanAgentQueryResult == null) {
            try {
                booleanAgentQueryResult = booleanAgentServices.query(instanceId, returnedFieldValues);
            }
            catch (Exception e) {
                throw new BackEndRequestFailedCpeException((Throwable)e);
            }
            if (languagesEnum == null) {
                document.addBooleanAgentQueryResult(fieldName, booleanAgentQueryResult);
            } else {
                document.addBooleanAgentQueryResult(fieldName, languagesEnum, booleanAgentQueryResult);
            }
        }
        return booleanAgentQueryResult;
    }

    public Collection<String> handleRegexExpression(DocumentUnderEvaluation document, String fieldName, String expression) throws CpeException {
        Pattern pattern = this.matcherFactory.getPattern(expression);
        HashSet<String> matchedStrings = new HashSet<String>();
        Collection<MetadataValue> returnedfieldValues = this.getFieldValues(document, fieldName);
        this.getMatches(pattern, returnedfieldValues, matchedStrings);
        return matchedStrings;
    }

    private Collection<MetadataValue> getFieldValues(DocumentUnderEvaluation document, String fieldName) {
        ArrayList<MetadataValue> fieldValues = new ArrayList<MetadataValue>();
        fieldValues.addAll(document.getValues(fieldName));
        return fieldValues;
    }

    private void getMatches(Pattern pattern, Collection<MetadataValue> fieldValues, HashSet<String> matchedStrings) {
        for (MetadataValue fieldValue : fieldValues) {
            MatcherWithTimeout matcher = new MatcherWithTimeout(pattern.matcher(fieldValue.getStringValue()), this.engineProperties.getRegexTimeout().intValue());
            while (matcher.find()) {
                matchedStrings.add(matcher.group());
            }
        }
    }

    private boolean isValidForLanguage(LanguagesEnum language, MetadataValue metadataValue) {
        String value = metadataValue.getAsString();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        if (language == null) {
            return true;
        }
        switch (language) {
            case Chinese: {
                return chinesePattern.matcher(value).find();
            }
            case Korean: {
                return koreanPattern.matcher(value).find();
            }
            case Japanese: {
                return japanesePattern.matcher(value).find();
            }
            case Thai: {
                return thaiPattern.matcher(value).find();
            }
        }
        return true;
    }
}

