/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.DateCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.DateOperator;
import com.github.cafdataprocessing.corepolicy.common.fields.DateFieldParser;
import com.github.cafdataprocessing.corepolicy.common.fields.DateParsingException;
import com.github.cafdataprocessing.corepolicy.common.shared.DateHelper;
import com.github.cafdataprocessing.corepolicy.common.shared.MetadataValue;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Strings;
import java.util.function.BiFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="DateCondition")
public class DateEvaluator
extends FieldConditionEvaluator<DateCondition> {
    @Autowired
    public DateEvaluator(ApiProperties apiProperties) {
        super(apiProperties);
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, DateCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        DateTime targetDate = null;
        BiFunction<DateTime, DateOperator, Boolean> dateComparer = null;
        if (DateHelper.isPeriod((String)condition.value)) {
            Period period = Period.parse((String)condition.value);
            targetDate = new DateTime(DateTimeZone.UTC);
            targetDate = targetDate.minus((ReadablePeriod)period);
            dateComparer = this.getTwoDatesComparer(targetDate);
        } else if (DateHelper.isTime((String)condition.value)) {
            LocalTime localTime = LocalTime.parse((String)condition.value, (DateTimeFormatter)ISODateTimeFormat.localTimeParser().withZoneUTC());
            dateComparer = this.getTwoTimesComparer(localTime);
        } else if (DateHelper.isDay((String)condition.value)) {
            dateComparer = this.getDayComparer(condition.value);
        } else {
            try {
                targetDate = DateFieldParser.parse((String)condition.value);
            }
            catch (DateParsingException e) {
                targetDate = null;
            }
            dateComparer = this.getTwoDatesComparer(targetDate);
        }
        for (MetadataValue fieldValue : document.getValues(condition.field)) {
            DateTime fieldDataTimeValue;
            try {
                fieldDataTimeValue = DateFieldParser.parse((String)fieldValue.getAsString());
            }
            catch (DateParsingException ex) {
                continue;
            }
            if (!dateComparer.apply(fieldDataTimeValue, condition.operator).booleanValue()) continue;
            result.setMatch(true);
            break;
        }
        result.populateEvaluationResult(result.isMatch(), (Condition)condition, document, true);
    }

    private BiFunction<DateTime, DateOperator, Boolean> getDayComparer(String day) {
        return (date, dateOperator) -> {
            if (Strings.isNullOrEmpty((String)day) || date == null) {
                return false;
            }
            int numberedDay = DateHelper.getNumberedDay((String)day);
            if (numberedDay == -1) {
                return false;
            }
            int result = Integer.compare(date.getDayOfWeek(), numberedDay);
            return this.resultMatchesOperator(result, (DateOperator)dateOperator);
        };
    }

    private BiFunction<DateTime, DateOperator, Boolean> getTwoDatesComparer(DateTime targetDate) {
        return (date, dateOperator) -> {
            if (targetDate == null || date == null) {
                return false;
            }
            int result = date.getMillis() == targetDate.getMillis() ? 0 : (date.getMillis() < targetDate.getMillis() ? -1 : 1);
            return this.resultMatchesOperator(result, (DateOperator)dateOperator);
        };
    }

    private BiFunction<DateTime, DateOperator, Boolean> getTwoTimesComparer(LocalTime targetDate) {
        return (date, dateOperator) -> {
            if (targetDate == null || date == null) {
                return false;
            }
            int result = date.toLocalTime().compareTo((ReadablePartial)targetDate);
            return this.resultMatchesOperator(result, (DateOperator)dateOperator);
        };
    }

    private Boolean resultMatchesOperator(int result, DateOperator dateOperator) {
        switch (dateOperator) {
            case ON: {
                return result == 0;
            }
            case BEFORE: {
                return result == -1;
            }
            case AFTER: {
                return result == 1;
            }
        }
        return false;
    }
}

