/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.FieldLabel;
import com.github.cafdataprocessing.corepolicy.common.dto.UnevaluatedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FieldCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluatorBase;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Strings;

abstract class FieldConditionEvaluator<T extends FieldCondition>
extends ConditionEvaluatorBase<T> {
    protected final ApiProperties apiProperties;

    public FieldConditionEvaluator(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
    }

    protected FieldStatus fieldMissing(DocumentUnderEvaluation document, T condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        if (Strings.isNullOrEmpty((String)((FieldCondition)condition).field)) {
            throw new IllegalArgumentException("Condition must have a field.");
        }
        FieldLabel fieldLabel = environmentSnapshot.getFieldLabel(((FieldCondition)condition).field);
        if (fieldLabel == null) {
            return this.checkField(document, ((FieldCondition)condition).field, environmentSnapshot);
        }
        if (document.hasLabelValues(fieldLabel.name)) {
            return new FieldStatus();
        }
        for (String field : fieldLabel.fields) {
            FieldStatus fieldStatus = this.checkField(document, field, environmentSnapshot);
            if (fieldStatus != null && fieldStatus.reasonForMissingField != null) continue;
            document.addLabelValues(fieldLabel.name, document.getMetadata().get((Object)field));
            document.addLabelValues(fieldLabel.name, document.getStreams().get((Object)field));
            return fieldStatus;
        }
        FieldStatus fieldStatus = new FieldStatus();
        fieldStatus.fieldMissing = true;
        fieldStatus.reasonForMissingField = UnevaluatedCondition.Reason.MISSING_FIELD;
        fieldStatus.missingField = ((FieldCondition)condition).field;
        return fieldStatus;
    }

    @Override
    protected void evaluate(CollectionSequence collectionSequence, ConditionEvaluationResult result, DocumentUnderEvaluation document, T condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        if (this.checkForCachedEvaluationResults(result, document, (Condition)condition)) {
            return;
        }
        if (this.checkForUnevaluatedCondition(result, document, condition, environmentSnapshot)) {
            return;
        }
        this.evaluateFieldValues(result, condition, document, environmentSnapshot);
    }

    protected abstract void evaluateFieldValues(ConditionEvaluationResult var1, T var2, DocumentUnderEvaluation var3, EnvironmentSnapshot var4);

    private FieldStatus checkField(DocumentUnderEvaluation document, String fieldName, EnvironmentSnapshot environmentSnapshot) {
        FieldStatus fieldStatus = new FieldStatus();
        if (document.getMetadata().containsKey((Object)fieldName) || document.getStreams().containsKey((Object)fieldName)) {
            return fieldStatus;
        }
        fieldStatus.fieldMissing = true;
        fieldStatus.missingField = fieldName;
        fieldStatus.reasonForMissingField = UnevaluatedCondition.Reason.MISSING_FIELD;
        return fieldStatus;
    }

    protected boolean checkForUnevaluatedCondition(ConditionEvaluationResult result, DocumentUnderEvaluation document, T condition, EnvironmentSnapshot environmentSnapshot) {
        FieldStatus fieldStatus = this.fieldMissing(document, condition, environmentSnapshot);
        if (!fieldStatus.fieldMissing) {
            return false;
        }
        boolean unEvaluated = false;
        if (fieldStatus.reasonForMissingField == UnevaluatedCondition.Reason.MISSING_SERVICE) {
            unEvaluated = true;
        } else if (fieldStatus.reasonForMissingField == UnevaluatedCondition.Reason.MISSING_FIELD) {
            if (fieldStatus.missingField == null) {
                unEvaluated = true;
            } else {
                boolean bl = unEvaluated = !document.getFullMetadata();
            }
        }
        if (unEvaluated) {
            this.recordUnevaluatedCondition(result, (Condition)condition, fieldStatus.reasonForMissingField);
            return true;
        }
        return false;
    }

    protected void recordUnevaluatedCondition(ConditionEvaluationResult result, Condition condition, UnevaluatedCondition.Reason reason) {
        UnevaluatedCondition unevaluatedCondition = new UnevaluatedCondition(condition, reason);
        result.getUnevaluatedConditions().add(unevaluatedCondition);
    }

    protected static class FieldStatus {
        boolean fieldMissing;
        String missingField;
        UnevaluatedCondition.Reason reasonForMissingField;

        protected FieldStatus() {
        }
    }
}

