/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.FragmentCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluatorBase;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.EvaluateCondition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="FragmentCondition")
class FragmentPointerEvaluator
extends ConditionEvaluatorBase<FragmentCondition> {
    private EvaluateCondition evaluateCondition;

    @Autowired
    public FragmentPointerEvaluator(EvaluateCondition evaluateCondition) {
        this.evaluateCondition = evaluateCondition;
    }

    @Override
    protected void evaluate(CollectionSequence collectionSequence, ConditionEvaluationResult result, DocumentUnderEvaluation document, FragmentCondition condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        if (condition.value == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Condition Fragment id " + condition.id + " has no target condition."));
        }
        Condition subCondition = environmentSnapshot.getCondition(condition.value);
        ConditionEvaluationResult subConditionResult = this.evaluateCondition.evaluate(collectionSequence, document, subCondition, environmentSnapshot);
        if (subConditionResult.isMatch()) {
            // empty if block
        }
        result.populateEvaluationResult(subConditionResult, true);
    }
}

