/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentQueryResult;
import com.github.cafdataprocessing.corepolicy.booleanagent.BooleanAgentServices;
import com.github.cafdataprocessing.corepolicy.common.ApiProperties;
import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.Lexicon;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpression;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpressionId;
import com.github.cafdataprocessing.corepolicy.common.dto.LexiconExpressionType;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.MatchedLexiconExpression;
import com.github.cafdataprocessing.corepolicy.common.dto.UnevaluatedCondition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.LexiconCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ContentExpressionHelper;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.FieldConditionEvaluator;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="LexiconCondition")
class LexiconEvaluator
extends FieldConditionEvaluator<LexiconCondition> {
    private final BooleanAgentServices booleanAgentServices;
    private ContentExpressionHelper contentExpressionHelper;

    @Autowired
    public LexiconEvaluator(BooleanAgentServices booleanAgentServices, ContentExpressionHelper contentExpressionHelper, ApiProperties apiProperties) {
        super(apiProperties);
        this.booleanAgentServices = booleanAgentServices;
        this.contentExpressionHelper = contentExpressionHelper;
    }

    @Override
    protected void evaluateFieldValues(ConditionEvaluationResult result, LexiconCondition condition, DocumentUnderEvaluation document, EnvironmentSnapshot environmentSnapshot) {
        if (condition.value == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Lexicon Condition id " + condition.id + " has no target lexicon."));
        }
        Lexicon lexicon = environmentSnapshot.getLexicon(condition.value);
        Collection lexiconExpressions = lexicon.lexiconExpressions;
        boolean containsBooleanAgentExpressions = false;
        MatchedCondition matchedCondition = new MatchedCondition(document.getReference(), (Condition)condition);
        ArrayList<LexiconExpression> regexLexiconExpressions = new ArrayList<LexiconExpression>();
        for (LexiconExpression lexiconExpression : lexiconExpressions) {
            if (lexiconExpression.type == LexiconExpressionType.REGEX) {
                regexLexiconExpressions.add(lexiconExpression);
                continue;
            }
            if (!this.booleanAgentServices.getAvailable()) {
                this.recordUnevaluatedCondition(result, (Condition)condition, UnevaluatedCondition.Reason.MISSING_SERVICE);
            }
            containsBooleanAgentExpressions = true;
        }
        if (!regexLexiconExpressions.isEmpty()) {
            regexLexiconExpressions.parallelStream().forEach(le -> {
                try {
                    this.evaluateRegex(document, condition, matchedCondition, (LexiconExpression)le);
                }
                catch (Exception e) {
                    throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.GeneralFailure, (Throwable)e);
                }
            });
        }
        if (containsBooleanAgentExpressions) {
            this.evaluateBooleanAgent(environmentSnapshot, document, condition, matchedCondition);
        }
        if (!matchedCondition.getMatchedLexiconExpressions().isEmpty()) {
            result.populateEvaluationResult(matchedCondition);
        } else {
            result.populateEvaluationResult(false, (Condition)condition, document, false);
        }
    }

    private void evaluateBooleanAgent(EnvironmentSnapshot environmentSnapshot, DocumentUnderEvaluation document, LexiconCondition condition, MatchedCondition matchedCondition) throws CpeException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        BooleanAgentQueryResult booleanAgentQueryResult = this.contentExpressionHelper.handleBooleanAgentExpression(environmentSnapshot.getInstanceId(), this.booleanAgentServices, document, condition.field, condition.language);
        document.logTime("Evaluate-LexiconCondition-Query", stopwatch);
        List lexiconExpressionIdList = booleanAgentQueryResult.getLexiconExpressionIdTerms().asMap().keySet().stream().filter(lei -> lei.lexiconId.equals(lexiconCondition.value)).collect(Collectors.toList());
        if (!lexiconExpressionIdList.isEmpty()) {
            for (LexiconExpressionId lexiconExpressionId : lexiconExpressionIdList) {
                MatchedLexiconExpression matchedLexiconExpression = new MatchedLexiconExpression();
                matchedLexiconExpression.setLexiconExpressionId(lexiconExpressionId.lexiconExpressionId);
                for (String match : booleanAgentQueryResult.getLexiconExpressionIdTerms().get((Object)lexiconExpressionId)) {
                    matchedLexiconExpression.getTerms().add(match);
                }
                matchedCondition.getMatchedLexiconExpressions().add(matchedLexiconExpression);
            }
        }
    }

    private void evaluateRegex(DocumentUnderEvaluation document, LexiconCondition condition, MatchedCondition matchedCondition, LexiconExpression lexiconExpression) throws CpeException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Collection<String> matches = this.contentExpressionHelper.handleRegexExpression(document, condition.field, lexiconExpression.expression);
        document.logTime("Evaluate-LexiconCondition-Regex", stopwatch);
        if (!matches.isEmpty()) {
            MatchedLexiconExpression matchedLexiconExpression = new MatchedLexiconExpression();
            matchedLexiconExpression.setLexiconExpressionId(lexiconExpression.id);
            for (String match : matches) {
                matchedLexiconExpression.getTerms().add(match);
            }
            matchedCondition.getMatchedLexiconExpressions().add(matchedLexiconExpression);
        }
    }
}

