/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.corepolicy.conditionEvaluators;

import com.github.cafdataprocessing.corepolicy.common.EnvironmentSnapshot;
import com.github.cafdataprocessing.corepolicy.common.dto.CollectionSequence;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.Condition;
import com.github.cafdataprocessing.corepolicy.common.dto.conditions.NotCondition;
import com.github.cafdataprocessing.corepolicy.common.exceptions.BackEndRequestFailedCpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.CpeException;
import com.github.cafdataprocessing.corepolicy.common.exceptions.excpetionErrors.BackEndRequestFailedErrors;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluationResult;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.ConditionEvaluatorBase;
import com.github.cafdataprocessing.corepolicy.conditionEvaluators.EvaluateCondition;
import com.github.cafdataprocessing.corepolicy.document.DocumentUnderEvaluation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="NotCondition")
class NotEvaluator
extends ConditionEvaluatorBase<NotCondition> {
    private EvaluateCondition evaluateCondition;

    @Autowired
    public NotEvaluator(EvaluateCondition evaluateCondition) {
        this.evaluateCondition = evaluateCondition;
    }

    @Override
    protected void evaluate(CollectionSequence collectionSequence, ConditionEvaluationResult result, DocumentUnderEvaluation document, NotCondition condition, EnvironmentSnapshot environmentSnapshot) throws CpeException {
        if (condition.condition == null) {
            throw new BackEndRequestFailedCpeException(BackEndRequestFailedErrors.InvalidDataDetected, (Throwable)new Exception("Not Condition id " + condition.id + " has no target condition."));
        }
        if (this.checkForCachedEvaluationResults(result, document, (Condition)condition)) {
            return;
        }
        Condition subCondition = condition.condition;
        ConditionEvaluationResult subConditionResult = this.evaluateCondition.evaluate(collectionSequence, document, subCondition, environmentSnapshot);
        if (!subConditionResult.getUnevaluatedConditions().isEmpty()) {
            result.setMatch(false);
            result.getUnevaluatedConditions().addAll(subConditionResult.getUnevaluatedConditions());
            return;
        }
        result.populateEvaluationResult(!subConditionResult.isMatch(), (Condition)condition, document, false);
    }
}

